/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.controller;

import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleEngineType;
import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleJobType;
import cn.sliew.carp.framework.log.annotation.WebLog;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.scheduler.executor.api.dict.CarpScheduleExecuteType;
import cn.sliew.carp.module.scheduler.service.ScheduleJobExecutorService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@WebLog
@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/schedule/executor"})
@Tag(name="\u8c03\u5ea6\u7ba1\u7406-\u6267\u884c\u5668\u7ba1\u7406")
public class CarpJobExecutorController {
    @Autowired
    private ScheduleJobExecutorService scheduleJobExecutorService;

    @GetMapping(value={"engines"})
    @Operation(summary="\u5f15\u64ce", description="\u5f15\u64ce")
    public List<CarpScheduleEngineType> getEngines() {
        return this.scheduleJobExecutorService.getEngines();
    }

    @GetMapping(value={"{engine}/types"})
    @Operation(summary="\u7c7b\u578b", description="\u7c7b\u578b")
    public Set<CarpScheduleJobType> getTypes(@PathVariable(value="engine") CarpScheduleEngineType engineType) {
        return this.scheduleJobExecutorService.getTypes(engineType);
    }

    @GetMapping(value={"{engine}/{type}/executors"})
    @Operation(summary="\u6267\u884c\u5668", description="\u6267\u884c\u5668")
    public List<CarpScheduleExecuteType> getExecutorTypes(@PathVariable(value="engine") CarpScheduleEngineType engineType, @PathVariable(value="type") CarpScheduleJobType jobType) {
        return this.scheduleJobExecutorService.getExecutorTypes(engineType, jobType);
    }
}

