/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.datasource.controller;

import cn.sliew.carp.framework.common.dict.datasource.CarpDataSourceType;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.log.annotation.WebLog;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.datasource.modal.DataSourceInfo;
import cn.sliew.carp.module.datasource.service.CarpDsInfoService;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import cn.sliew.carp.module.datasource.service.param.DsInfoListParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@WebLog
@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/datasource/info"})
@Tag(name="\u6570\u636e\u6e90\u6a21\u5757-\u6570\u636e\u6e90\u7ba1\u7406")
public class CarpDsInfoController {
    @Autowired
    private CarpDsInfoService carpDsInfoService;

    @GetMapping(value={"page"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public PageResult<DsInfoDTO> list(@Valid DsInfoListParam param) {
        return this.carpDsInfoService.list(param);
    }

    @GetMapping(value={"{type}"})
    @Operation(summary="\u67e5\u8be2\u6240\u6709", description="\u67e5\u8be2\u6307\u5b9a\u6570\u636e\u6e90\u7c7b\u578b\u4e0b\u6240\u6709\u6570\u636e\u6e90")
    public List<DsInfoDTO> listByType(@PathVariable(value="type") CarpDataSourceType type) {
        return this.carpDsInfoService.listByType(type);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="\u67e5\u8be2\u8be6\u60c5", description="\u67e5\u8be2\u8be6\u60c5")
    public DsInfoDTO get(@PathVariable(value="id") Long id) {
        return this.carpDsInfoService.selectOne(id, false);
    }

    @PutMapping
    @Operation(summary="\u65b0\u589e", description="\u65b0\u589e")
    public boolean add(@Valid @RequestBody DataSourceInfo dataSource) {
        return this.carpDsInfoService.add(dataSource);
    }

    @PostMapping(value={"{id}"})
    @Operation(summary="\u66f4\u65b0", description="\u66f4\u65b0")
    public boolean update(@PathVariable(value="id") Long id, @Valid @RequestBody DataSourceInfo dataSource) {
        return this.carpDsInfoService.update(id, dataSource);
    }

    @DeleteMapping(value={"{id}"})
    @Operation(summary="\u5220\u9664", description="\u5220\u9664")
    public boolean delete(@PathVariable(value="id") Long id) {
        return this.carpDsInfoService.deleteById(id);
    }

    @DeleteMapping(value={"batch"})
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    public boolean deleteBatch(@RequestBody List<Long> ids) {
        return this.carpDsInfoService.deleteBatch(ids);
    }
}

