/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.datasource.service.impl;

import cn.sliew.carp.framework.common.codec.CodecUtil;
import cn.sliew.carp.framework.common.dict.datasource.CarpDataSourceType;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.datasource.config.CarpGravitinoProperties;
import cn.sliew.carp.module.datasource.modal.DataSourceInfo;
import cn.sliew.carp.module.datasource.repository.entity.DsInfo;
import cn.sliew.carp.module.datasource.repository.entity.DsInfoVO;
import cn.sliew.carp.module.datasource.repository.mapper.DsInfoMapper;
import cn.sliew.carp.module.datasource.service.CarpDsInfoService;
import cn.sliew.carp.module.datasource.service.CarpGravitinoMetalakeService;
import cn.sliew.carp.module.datasource.service.convert.DsInfoConvert;
import cn.sliew.carp.module.datasource.service.convert.DsInfoVOConvert;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import cn.sliew.carp.module.datasource.service.param.DsInfoListParam;
import cn.sliew.milky.common.check.Ensures;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CarpDsInfoServiceImpl
extends ServiceImpl<DsInfoMapper, DsInfo>
implements CarpDsInfoService {
    @Autowired
    private CarpGravitinoProperties properties;
    @Autowired
    private CarpGravitinoMetalakeService gravitinoMetalakeService;

    @Override
    public PageResult<DsInfoDTO> list(DsInfoListParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        Page<DsInfoVO> dsInfoPage = ((DsInfoMapper)this.baseMapper).list((Page<DsInfo>)page, param.getDsType(), param.getName());
        PageResult result = new PageResult(Long.valueOf(dsInfoPage.getCurrent()), Long.valueOf(dsInfoPage.getSize()), Long.valueOf(dsInfoPage.getTotal()));
        List dsInfoDTOS = DsInfoVOConvert.INSTANCE.toDto(dsInfoPage.getRecords());
        result.setRecords(dsInfoDTOS);
        return result;
    }

    @Override
    public List<DsInfoDTO> listByType(CarpDataSourceType type) {
        List<DsInfoVO> dsInfoVOS = ((DsInfoMapper)this.baseMapper).listByTypes(type);
        return DsInfoVOConvert.INSTANCE.toDto(dsInfoVOS);
    }

    @Override
    public DsInfoDTO selectOne(Long id, boolean decrypt) {
        DsInfoVO vo = ((DsInfoMapper)this.baseMapper).getById(id);
        Ensures.checkState((vo != null ? 1 : 0) != 0, () -> "data source info not exists for id: " + id);
        DsInfoDTO dsInfoDTO = DsInfoVOConvert.INSTANCE.toDto(vo);
        if (decrypt) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : dsInfoDTO.getProps().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (Objects.nonNull(value) && value instanceof String && CodecUtil.isEncryptedStr((String)((String)value))) {
                    props.put(key, CodecUtil.decrypt((String)((String)value)));
                    continue;
                }
                props.put(key, value);
            }
            dsInfoDTO.setProps(props);
        }
        return dsInfoDTO;
    }

    @Override
    public boolean add(DataSourceInfo dataSource) {
        DsInfo record = DsInfoConvert.INSTANCE.toDo(dataSource.toDsInfo());
        boolean save = this.save((Object)record);
        if (save) {
            this.gravitinoMetalakeService.tryAddCatalog(this.properties.getMetalake(), this.selectOne(record.getId(), true));
        }
        return save;
    }

    @Override
    public boolean update(Long id, DataSourceInfo dataSource) {
        DsInfo record = DsInfoConvert.INSTANCE.toDo(dataSource.toDsInfo());
        record.setId(id);
        boolean saveOrUpdate = this.saveOrUpdate((Object)record);
        if (saveOrUpdate) {
            this.gravitinoMetalakeService.tryUpdateCatalog(this.properties.getMetalake(), this.selectOne(record.getId(), true));
        }
        return saveOrUpdate;
    }

    @Override
    public boolean deleteById(Long id) {
        DsInfoDTO dsInfoDTO = this.selectOne(id, true);
        boolean remove = this.removeById(id);
        if (remove) {
            this.gravitinoMetalakeService.tryDeleteCatalog(this.properties.getMetalake(), dsInfoDTO);
        }
        return remove;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return true;
        }
        List dsInfoDTOS = ids.stream().map(id -> this.selectOne((Long)id, true)).collect(Collectors.toList());
        boolean remove = this.removeBatchByIds(ids);
        if (remove) {
            for (DsInfoDTO dsInfoDTO : dsInfoDTOS) {
                this.gravitinoMetalakeService.tryDeleteCatalog(this.properties.getMetalake(), dsInfoDTO);
            }
        }
        return remove;
    }
}

