/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.executor.java;

import cn.hutool.core.bean.BeanUtil;
import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleEngineType;
import cn.sliew.carp.framework.common.dict.schedule.CarpScheduleJobType;
import cn.sliew.carp.module.scheduler.executor.api.dict.CarpScheduleExecuteType;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobContext;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobExecutor;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobHandler;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobHandlerFactory;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobHandlerFactoryRegistry;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobThread;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobThreadRepository;
import cn.sliew.carp.module.scheduler.executor.api.executor.entity.ScheduleResponse;
import cn.sliew.carp.module.scheduler.executor.api.executor.entity.job.JobExecutionResult;
import cn.sliew.carp.module.scheduler.executor.api.executor.entity.trigger.TriggerParam;
import cn.sliew.milky.common.exception.Rethrower;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaJobExecutor
implements JobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaJobExecutor.class);
    private JobHandlerFactoryRegistry jobHandlerFactoryRegistry;
    private JobThreadRepository jobThreadRepository;

    public JavaJobExecutor(JobHandlerFactoryRegistry jobHandlerFactoryRegistry, JobThreadRepository jobThreadRepository) {
        this.jobHandlerFactoryRegistry = jobHandlerFactoryRegistry;
        this.jobThreadRepository = jobThreadRepository;
    }

    public List<CarpScheduleEngineType> getEngines() {
        return Collections.singletonList(CarpScheduleEngineType.INTERNAL);
    }

    public CarpScheduleJobType getType() {
        return CarpScheduleJobType.NORMAL;
    }

    public List<CarpScheduleExecuteType> getSupportExecuteTypes() {
        return Arrays.asList(CarpScheduleExecuteType.BEAN, CarpScheduleExecuteType.METHOD);
    }

    public ScheduleResponse execute(TriggerParam param) {
        if (!this.jobHandlerFactoryRegistry.exist(param.getExecuteType())) {
            return new ScheduleResponse("-1", "unknown execute type: " + param.getExecuteType());
        }
        JobHandlerFactory jobHandlerFactory = this.jobHandlerFactoryRegistry.get(CarpScheduleExecuteType.of((String)param.getExecuteType()));
        JobHandler jobHandler = jobHandlerFactory.newInstance(param.getJobHandler());
        JobContext context = (JobContext)BeanUtil.copyProperties((Object)param, JobContext.class, (String[])new String[0]);
        JobThread jobThread = new JobThread(jobHandler, context);
        this.jobThreadRepository.save(jobThread);
        CompletableFuture.supplyAsync(() -> {
            try {
                return (JobExecutionResult)jobThread.call();
            }
            catch (Exception e) {
                Rethrower.throwAs((Throwable)e);
                return null;
            }
        }).whenComplete((result, throwable) -> {
            if (throwable != null) {
                log.error(throwable.getMessage(), throwable);
            } else {
                log.info("{}", result);
            }
            this.jobThreadRepository.remove(jobThread.getJobId(), jobThread.getJobInstanceId());
        });
        return ScheduleResponse.SUCCESS;
    }
}

