/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.executor.java.handler.method;

import cn.sliew.carp.module.scheduler.executor.api.executor.JobContext;
import cn.sliew.carp.module.scheduler.executor.api.executor.JobHandler;
import cn.sliew.carp.module.scheduler.executor.api.executor.entity.job.JobExecutionResult;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.util.ReflectionUtils;

public class MethodJobHandler
implements JobHandler {
    private final Object target;
    private final Method method;
    private Method initMethod;
    private Method destroyMethod;

    public MethodJobHandler(Object target, Method method, Method initMethod, Method destroyMethod) {
        this.target = target;
        this.method = method;
        this.initMethod = initMethod;
        this.destroyMethod = destroyMethod;
    }

    public JobExecutionResult init(JobContext context) {
        if (Objects.isNull(this.initMethod)) {
            return null;
        }
        try {
            Object result = ReflectionUtils.invokeMethod((Method)this.initMethod, (Object)this.target, (Object[])new Object[]{context});
            if (Objects.nonNull(result) && result instanceof JobExecutionResult) {
                return (JobExecutionResult)result;
            }
        }
        catch (Exception e) {
            return JobExecutionResult.failed((String)"-1", (String)"init method failed", (Throwable)e);
        }
        return null;
    }

    public void destroy(JobContext context) {
        if (Objects.isNull(this.destroyMethod)) {
            return;
        }
        try {
            ReflectionUtils.invokeMethod((Method)this.destroyMethod, (Object)this.target, (Object[])new Object[]{context});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JobExecutionResult execute(JobContext context) {
        try {
            Object result = ReflectionUtils.invokeMethod((Method)this.method, (Object)this.target, (Object[])new Object[]{context});
            if (Objects.nonNull(result) && result instanceof JobExecutionResult) {
                return (JobExecutionResult)result;
            }
            return JobExecutionResult.failed((String)"-1", (String)"job method not return JobExecutionResult", null);
        }
        catch (Exception e) {
            return JobExecutionResult.failed((String)"-1", (String)"job method failed", (Throwable)e);
        }
    }
}

