/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.dataservice.domain.dao.mybatis;

import cn.sliew.carp.framework.common.model.PageParam;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.mybatis.config.CarpMybatisConfig;
import cn.sliew.carp.framework.spring.util.PageUtil;
import cn.sliew.carp.module.dataservice.domain.dao.DaoExecutor;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.JdbcExecutor;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.entity.MybatisDynamicParamDTO;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.entity.ParamType;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.mapper.MybatisMapper;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.mapper.SqlWrapperProvider;
import cn.sliew.carp.module.datasource.modal.AbstractDataSourceProperties;
import cn.sliew.carp.module.datasource.modal.jdbc.MySQLDataSourceProperties;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.stereotype.Component;

@Component
public class MybatisDaoExecutor
implements DaoExecutor {
    private ConcurrentMap<Long, SqlSessionFactory> configurationRegistry = new ConcurrentHashMap<Long, SqlSessionFactory>();
    private MybatisConfiguration defaultConfiguration = new MybatisConfiguration();

    private SqlSessionFactory getSqlSessionFactory(DsInfoDTO dsInfoDTO) {
        return this.configurationRegistry.computeIfAbsent(dsInfoDTO.getId(), k -> {
            try {
                AbstractDataSourceProperties dataSourceProperties = (AbstractDataSourceProperties)JacksonUtil.toObject((JsonNode)JacksonUtil.toJsonNode((Object)dsInfoDTO.getProps()), AbstractDataSourceProperties.class);
                MySQLDataSourceProperties mySQLDataSourceProperties = (MySQLDataSourceProperties)dataSourceProperties;
                HikariDataSource dataSource = (HikariDataSource)DataSourceBuilder.create().type(HikariDataSource.class).build();
                dataSource.setPoolName(dsInfoDTO.getName());
                dataSource.setDriverClassName(mySQLDataSourceProperties.getDriverClassName());
                dataSource.setJdbcUrl(mySQLDataSourceProperties.getUrl());
                dataSource.setUsername(mySQLDataSourceProperties.getUser());
                dataSource.setPassword(mySQLDataSourceProperties.getPassword());
                dataSource.setMinimumIdle(1);
                dataSource.setMaximumPoolSize(5);
                MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
                GlobalConfig globalConfig = GlobalConfigUtils.defaults();
                globalConfig.setMetaObjectHandler((MetaObjectHandler)new CarpMybatisConfig.CarpMetaHandler());
                MybatisPlusProperties props = new MybatisPlusProperties();
                props.setMapperLocations(new String[]{"classpath*:cn/sliew/carp/**/repository/**/*.xml"});
                factoryBean.setMapperLocations(props.resolveMapperLocations());
                MybatisConfiguration configuration = new MybatisConfiguration();
                configuration.addMapper(MybatisMapper.class);
                configuration.addMapper(SqlWrapperProvider.class);
                configuration.setDefaultEnumTypeHandler(MybatisEnumTypeHandler.class);
                configuration.setMapUnderscoreToCamelCase(true);
                configuration.setLogImpl(Slf4jImpl.class);
                factoryBean.setConfiguration(configuration);
                factoryBean.setGlobalConfig(globalConfig);
                factoryBean.setDataSource((DataSource)dataSource);
                return factoryBean.getObject();
            }
            catch (Exception e) {
                Rethrower.throwAs((Throwable)e);
                return null;
            }
        });
    }

    private Configuration getConfiguration(DsInfoDTO dsInfoDTO) {
        return this.getSqlSessionFactory(dsInfoDTO).getConfiguration();
    }

    @Override
    public PageResult<String> page(DsInfoDTO dsInfoDTO, PageParam param) {
        return PageUtil.buildPage((PageParam)param, this.listAll(dsInfoDTO));
    }

    @Override
    public List<String> listAll(DsInfoDTO dsInfoDTO) {
        return this.getConfiguration(dsInfoDTO).getMappedStatementNames().stream().toList();
    }

    @Override
    public void register(String id, String sqlScript, DsInfoDTO dsInfoDTO) {
        this.getConfiguration(dsInfoDTO).addMappedStatement(this.buildMappedStatement(id, sqlScript));
    }

    @Override
    public void unregister(String id, DsInfoDTO dsInfoDTO) {
        Map mappedStatements = (Map)this.readField(this.getConfiguration(dsInfoDTO), "mappedStatements");
        mappedStatements.remove(id);
    }

    @Override
    public List parseParams(String sqlScript) {
        List<MybatisDynamicParamDTO> dynamicParamDTOS;
        MappedStatement mappedStatement = this.buildMappedStatement(UUIDUtil.randomUUId(), sqlScript);
        SqlSource sqlSource = mappedStatement.getSqlSource();
        if (sqlSource instanceof RawSqlSource) {
            dynamicParamDTOS = this.parseRawSqlSourceParam((RawSqlSource)sqlSource);
        } else if (sqlSource instanceof DynamicSqlSource) {
            dynamicParamDTOS = this.parseDynamicSqlSourceParam((DynamicSqlSource)sqlSource);
        } else {
            throw new IllegalStateException("mybatis mappedstatement type error: " + sqlScript);
        }
        Map<String, List<MybatisDynamicParamDTO>> collect = dynamicParamDTOS.stream().filter(paramDTO -> paramDTO.getParamType() == ParamType.PLACEHOLDER_COMPILE || paramDTO.getParamType() == ParamType.PLACEHOLDER_REPLACE || paramDTO.getParamType() == ParamType.VARIABLE_TEST).collect(Collectors.groupingBy(MybatisDynamicParamDTO::getName));
        return collect.values().stream().map(list -> (MybatisDynamicParamDTO)list.get(0)).collect(Collectors.toList());
    }

    private List<MybatisDynamicParamDTO> parseRawSqlSourceParam(RawSqlSource sqlSource) {
        StaticSqlSource staticSqlSource = (StaticSqlSource)this.readField(sqlSource, "sqlSource");
        List parameterMappings = (List)this.readField(staticSqlSource, "parameterMappings");
        return parameterMappings.stream().map(parameterMapping -> {
            MybatisDynamicParamDTO dto = new MybatisDynamicParamDTO();
            dto.setName(parameterMapping.getProperty());
            dto.setSource(null);
            dto.setRequired(true);
            dto.setParamType(ParamType.PLACEHOLDER_COMPILE);
            return dto;
        }).collect(Collectors.toList());
    }

    private List<MybatisDynamicParamDTO> parseDynamicSqlSourceParam(DynamicSqlSource sqlSource) {
        SqlNode sqlNode = (SqlNode)this.readField(sqlSource, "rootSqlNode");
        return this.parseSqlNode(sqlNode, true);
    }

    private List<MybatisDynamicParamDTO> parseSqlNode(SqlNode sqlNode, boolean required) {
        if (sqlNode instanceof MixedSqlNode) {
            return this.parseMixedSqlNodeParam((MixedSqlNode)sqlNode, required);
        }
        if (sqlNode instanceof TextSqlNode) {
            return this.parseTextSqlNodeParam((TextSqlNode)sqlNode, required);
        }
        if (sqlNode instanceof StaticTextSqlNode) {
            return this.parseStaticTextSqlNodeParam((StaticTextSqlNode)sqlNode, required);
        }
        if (sqlNode instanceof IfSqlNode) {
            return this.parseIfSqlNodeParam((IfSqlNode)sqlNode);
        }
        if (sqlNode instanceof ForEachSqlNode) {
            return this.parseForEachSqlNodeParam((ForEachSqlNode)sqlNode, required);
        }
        if (sqlNode instanceof ChooseSqlNode) {
            return this.parseChooseSqlNodeParam((ChooseSqlNode)sqlNode);
        }
        if (sqlNode instanceof TrimSqlNode) {
            return this.parseTrimSqlNodeParam((TrimSqlNode)sqlNode, required);
        }
        if (sqlNode instanceof VarDeclSqlNode) {
            return this.parseVarDeclSqlNodeParam((VarDeclSqlNode)sqlNode, required);
        }
        return Collections.emptyList();
    }

    private List<MybatisDynamicParamDTO> parseMixedSqlNodeParam(MixedSqlNode sqlNode, boolean required) {
        List contents = (List)this.readField(sqlNode, "contents");
        return contents.stream().map(node -> this.parseSqlNode((SqlNode)node, required)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<MybatisDynamicParamDTO> parseTextSqlNodeParam(TextSqlNode sqlNode, boolean required) {
        ArrayList<MybatisDynamicParamDTO> all = new ArrayList<MybatisDynamicParamDTO>();
        TextSqlNodeTokenHandler handler1 = new TextSqlNodeTokenHandler();
        GenericTokenParser parser1 = new GenericTokenParser("${", "}", (TokenHandler)handler1);
        parser1.parse((String)this.readField(sqlNode, "text"));
        all.addAll(handler1.getParamSet().stream().map(param -> new MybatisDynamicParamDTO((String)param, ParamType.PLACEHOLDER_REPLACE, null, required)).collect(Collectors.toList()));
        TextSqlNodeTokenHandler handler2 = new TextSqlNodeTokenHandler();
        GenericTokenParser parser2 = new GenericTokenParser("#{", "}", (TokenHandler)handler2);
        parser2.parse((String)this.readField(sqlNode, "text"));
        all.addAll(handler2.getParamSet().stream().map(param -> new MybatisDynamicParamDTO((String)param, ParamType.PLACEHOLDER_COMPILE, null, required)).collect(Collectors.toList()));
        return all;
    }

    private List<MybatisDynamicParamDTO> parseStaticTextSqlNodeParam(StaticTextSqlNode sqlNode, boolean required) {
        TextSqlNodeTokenHandler handler = new TextSqlNodeTokenHandler();
        GenericTokenParser parser = new GenericTokenParser("#{", "}", (TokenHandler)handler);
        parser.parse((String)this.readField(sqlNode, "text"));
        return handler.getParamSet().stream().map(param -> new MybatisDynamicParamDTO((String)param, ParamType.PLACEHOLDER_COMPILE, null, required)).collect(Collectors.toList());
    }

    private List<MybatisDynamicParamDTO> parseIfSqlNodeParam(IfSqlNode sqlNode) {
        ArrayList<MybatisDynamicParamDTO> dynamicParamDTOS = new ArrayList<MybatisDynamicParamDTO>();
        String test = (String)this.readField(sqlNode, "test");
        dynamicParamDTOS.addAll(this.parseTestExpression(test));
        SqlNode contents = (SqlNode)this.readField(sqlNode, "contents");
        dynamicParamDTOS.addAll(this.parseSqlNode(contents, false));
        return dynamicParamDTOS;
    }

    private List<MybatisDynamicParamDTO> parseForEachSqlNodeParam(ForEachSqlNode sqlNode, boolean required) {
        String index;
        ArrayList<MybatisDynamicParamDTO> forEachParamList = new ArrayList<MybatisDynamicParamDTO>();
        String collectionExpression = (String)this.readField(sqlNode, "collectionExpression");
        forEachParamList.add(new MybatisDynamicParamDTO(collectionExpression, ParamType.PLACEHOLDER_COMPILE, null, required));
        String item = (String)this.readField(sqlNode, "item");
        if (item != null) {
            forEachParamList.add(new MybatisDynamicParamDTO(item, ParamType.VARIABLE_FOREACH, collectionExpression, false));
        }
        if ((index = (String)this.readField(sqlNode, "index")) != null) {
            forEachParamList.add(new MybatisDynamicParamDTO(index, ParamType.VARIABLE_FOREACH, collectionExpression, false));
        }
        return forEachParamList;
    }

    private List<MybatisDynamicParamDTO> parseChooseSqlNodeParam(ChooseSqlNode sqlNode) {
        ArrayList<MybatisDynamicParamDTO> chooseParamList = new ArrayList<MybatisDynamicParamDTO>();
        List ifSqlNodes = (List)this.readField(sqlNode, "ifSqlNodes");
        ifSqlNodes.forEach(content -> chooseParamList.addAll(this.parseSqlNode((SqlNode)content, false)));
        SqlNode defaultSqlNode = (SqlNode)this.readField(sqlNode, "defaultSqlNode");
        if (defaultSqlNode != null) {
            chooseParamList.addAll(this.parseSqlNode(defaultSqlNode, false));
        }
        return chooseParamList;
    }

    private List<MybatisDynamicParamDTO> parseTrimSqlNodeParam(TrimSqlNode sqlNode, boolean required) {
        SqlNode contents = (SqlNode)this.readField(TrimSqlNode.class, sqlNode, "contents");
        return this.parseSqlNode(contents, required);
    }

    private List<MybatisDynamicParamDTO> parseVarDeclSqlNodeParam(VarDeclSqlNode sqlNode, boolean required) {
        String name = (String)this.readField(sqlNode, "name");
        String expression = (String)this.readField(sqlNode, "expression");
        return Collections.singletonList(new MybatisDynamicParamDTO(name, ParamType.VARIABLE_BIND, expression, required));
    }

    private List<MybatisDynamicParamDTO> parseTestExpression(String test) {
        ArrayList<MybatisDynamicParamDTO> dynamicParamDTOS = new ArrayList<MybatisDynamicParamDTO>();
        String regex = "(\\w+)\\s*(?:!=|>=|<=|==|<|>|&lt;|&lt;=|&gt;|&gt;=)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(test);
        while (matcher.find()) {
            String field = matcher.group(1);
            dynamicParamDTOS.add(new MybatisDynamicParamDTO(field, ParamType.VARIABLE_TEST, null, true));
        }
        return dynamicParamDTOS;
    }

    @Override
    public String parseSql(String id, String sqlScript, Map<String, Object> params) {
        MappedStatement mappedStatement = this.buildMappedStatement(id, sqlScript);
        return mappedStatement.getBoundSql(params).getSql();
    }

    @Override
    public Object execute(String id, String sqlScript, Map<String, Object> params, DsInfoDTO dsInfoDTO) {
        Configuration configuration = this.getConfiguration(dsInfoDTO);
        Preconditions.checkState((boolean)configuration.hasStatement(id), (Object)("MappedStatement not found for id: " + id));
        return this.doExecute(dsInfoDTO, jdbcExecutor -> jdbcExecutor.selectOne(dsInfoDTO, sqlScript, params));
    }

    private Object doExecute(DsInfoDTO dsInfoDTO, Function<JdbcExecutor, Object> function) {
        Object object;
        block8: {
            SqlSessionFactory sqlSessionFactory = this.getSqlSessionFactory(dsInfoDTO);
            SqlSession sqlSession = sqlSessionFactory.openSession(false);
            try {
                MybatisMapper mapper = (MybatisMapper)sqlSession.getMapper(MybatisMapper.class);
                JdbcExecutor jdbcExecutor = new JdbcExecutor(mapper);
                object = function.apply(jdbcExecutor);
                if (sqlSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sqlSession != null) {
                        try {
                            sqlSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Rethrower.throwAs((Throwable)e);
                    return null;
                }
            }
            sqlSession.close();
        }
        return object;
    }

    private MappedStatement buildMappedStatement(String id, String sqlScript) {
        LanguageDriver languageDriver = this.defaultConfiguration.getDefaultScriptingLanguageInstance();
        SqlSource sqlSource = languageDriver.createSqlSource((Configuration)this.defaultConfiguration, sqlScript, null);
        MappedStatement.Builder builder = new MappedStatement.Builder((Configuration)this.defaultConfiguration, id, sqlSource, SqlCommandType.UNKNOWN);
        return builder.build();
    }

    private <T> T readField(Object object, String fieldName) {
        try {
            return (T)FieldUtils.readDeclaredField((Object)object, (String)fieldName, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T readField(Class clazz, Object object, String fieldName) {
        try {
            Field field = FieldUtils.getDeclaredField((Class)clazz, (String)fieldName, (boolean)true);
            return (T)FieldUtils.readField((Field)field, (Object)object, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static class TextSqlNodeTokenHandler
    implements TokenHandler {
        private Set<String> paramSet = new HashSet<String>();

        TextSqlNodeTokenHandler() {
        }

        public Set<String> getParamSet() {
            return this.paramSet;
        }

        public String handleToken(String content) {
            this.paramSet.add(content);
            return content;
        }
    }
}

