/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.spring.config;

import cn.sliew.carp.framework.spring.concurrent.MetricsThreadPoolExecutor;
import cn.sliew.carp.framework.spring.event.DelegatingApplicationEventMulticaster;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class AsyncConfig
implements AsyncConfigurer {
    private static final String NAME = "carpApplicationEventTaskExecutor";

    @Bean(name={"carpApplicationEventTaskExecutor"})
    public ThreadPoolTaskExecutor carpApplicationEventTaskExecutor(MeterRegistry registry) {
        MetricsThreadPoolExecutor threadPool = new MetricsThreadPoolExecutor(registry, Collections.emptyList());
        threadPool.setThreadNamePrefix("spring-events-async-thread-");
        int processors = Runtime.getRuntime().availableProcessors();
        threadPool.setCorePoolSize(processors);
        threadPool.setMaxPoolSize(processors * 3);
        return threadPool;
    }

    @Bean
    public ApplicationEventMulticaster applicationEventMulticaster(@Qualifier(value="carpApplicationEventTaskExecutor") ThreadPoolTaskExecutor taskExecutor) {
        SimpleApplicationEventMulticaster async = new SimpleApplicationEventMulticaster();
        async.setTaskExecutor((Executor)taskExecutor);
        SimpleApplicationEventMulticaster sync = new SimpleApplicationEventMulticaster();
        return new DelegatingApplicationEventMulticaster((ApplicationEventMulticaster)sync, (ApplicationEventMulticaster)async);
    }
}

