/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.spring.event;

import cn.sliew.carp.framework.spring.event.InspectableApplicationListenerMethodAdapter;
import cn.sliew.carp.framework.spring.event.Sync;
import java.util.function.Predicate;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.core.ResolvableType;

public class DelegatingApplicationEventMulticaster
implements ApplicationEventMulticaster,
BeanFactoryAware,
BeanClassLoaderAware {
    private final ApplicationEventMulticaster syncApplicationEventMulticaster;
    private final ApplicationEventMulticaster asyncApplicationEventMulticaster;

    public DelegatingApplicationEventMulticaster(ApplicationEventMulticaster syncApplicationEventMulticaster, ApplicationEventMulticaster asyncApplicationEventMulticaster) {
        this.syncApplicationEventMulticaster = syncApplicationEventMulticaster;
        this.asyncApplicationEventMulticaster = asyncApplicationEventMulticaster;
    }

    public void multicastEvent(ApplicationEvent event) {
        this.asyncApplicationEventMulticaster.multicastEvent(event);
        this.syncApplicationEventMulticaster.multicastEvent(event);
    }

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        this.asyncApplicationEventMulticaster.multicastEvent(event, eventType);
        this.syncApplicationEventMulticaster.multicastEvent(event, eventType);
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        if (this.isSynchronous(listener)) {
            this.syncApplicationEventMulticaster.addApplicationListener(listener);
        } else {
            this.asyncApplicationEventMulticaster.addApplicationListener(listener);
        }
    }

    private boolean isSynchronous(ApplicationListener<?> listener) {
        if (listener.getClass().getAnnotation(Sync.class) != null) {
            return true;
        }
        return listener instanceof InspectableApplicationListenerMethodAdapter && ((InspectableApplicationListenerMethodAdapter)listener).getMethod().getAnnotation(Sync.class) != null;
    }

    public void addApplicationListenerBean(String listenerBeanName) {
        this.asyncApplicationEventMulticaster.addApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListener(ApplicationListener<?> listener) {
        this.asyncApplicationEventMulticaster.removeApplicationListener(listener);
        this.syncApplicationEventMulticaster.removeApplicationListener(listener);
    }

    public void removeApplicationListenerBean(String listenerBeanName) {
        this.asyncApplicationEventMulticaster.removeApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListeners(Predicate<ApplicationListener<?>> predicate) {
        this.asyncApplicationEventMulticaster.removeApplicationListeners(predicate);
        this.syncApplicationEventMulticaster.removeApplicationListeners(predicate);
    }

    public void removeApplicationListenerBeans(Predicate<String> predicate) {
        this.asyncApplicationEventMulticaster.removeApplicationListenerBeans(predicate);
        this.syncApplicationEventMulticaster.removeApplicationListenerBeans(predicate);
    }

    public void removeAllListeners() {
        this.asyncApplicationEventMulticaster.removeAllListeners();
        this.syncApplicationEventMulticaster.removeAllListeners();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (this.asyncApplicationEventMulticaster instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.asyncApplicationEventMulticaster).setBeanFactory(beanFactory);
        }
        if (this.syncApplicationEventMulticaster instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.syncApplicationEventMulticaster).setBeanFactory(beanFactory);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (this.asyncApplicationEventMulticaster instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)this.asyncApplicationEventMulticaster).setBeanClassLoader(classLoader);
        }
        if (this.syncApplicationEventMulticaster instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)this.syncApplicationEventMulticaster).setBeanClassLoader(classLoader);
        }
    }
}

