/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.spring.util;

import cn.hutool.core.lang.UUID;
import cn.sliew.carp.framework.common.nio.FileUtil;
import java.io.IOException;
import java.nio.file.Path;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SystemUtil
implements InitializingBean,
DisposableBean {
    private static final String LOCAL_FS_STORAGE_DIR_NAME = "storage";
    private static String workspace;

    @Value(value="${app.workspace:/tmp/carp}")
    public void setWorkspace(String workspace) {
        SystemUtil.workspace = workspace;
    }

    public void afterPropertiesSet() throws Exception {
        FileUtil.deleteDir((Path)Path.of(workspace, new String[0]));
    }

    public void destroy() throws Exception {
        FileUtil.deleteDir((Path)Path.of(workspace, new String[0]));
    }

    public static Path getWorkspace() throws IOException {
        return FileUtil.createDir((Path)Path.of(workspace, new String[0]));
    }

    public static Path getRandomWorkspace() throws IOException {
        return FileUtil.createDir((Path)SystemUtil.getWorkspace().resolve(UUID.randomUUID().toString(true)));
    }

    public static Path getLocalStorageDir() throws IOException {
        return FileUtil.createDir((Path)SystemUtil.getWorkspace().resolve(LOCAL_FS_STORAGE_DIR_NAME));
    }

    public static Path getPluginsPath() throws IOException {
        return FileUtil.createDir((Path)SystemUtil.getWorkspace().resolve("plugins"));
    }

    public static Path getDataSourcePluginsPath() throws IOException {
        return FileUtil.createDir((Path)SystemUtil.getPluginsPath().resolve("datasource"));
    }

    public static Path getKubeConfigPath() throws IOException {
        return FileUtil.createDir((Path)SystemUtil.getWorkspace().resolve("kubeconfig"));
    }
}

