create database if not exists data_service default character set utf8mb4 collate utf8mb4_unicode_ci;
use data_service;

drop table if exists jst_auth;
create table `jst_auth`
(
    `id`            bigint       not null auto_increment comment '自增主键',
    `app_key`       varchar(128) not null comment 'key',
    `app_secret`    varchar(128) not null comment 'secret',
    `company`       varchar(255) not null comment '公司名称',
    `access_token`  varchar(128) comment '访问令牌',
    `refresh_token` varchar(128) comment '更新令牌',
    `expires_in`    bigint(20) comment 'access_token访问过期时间【单位是秒】，还有多少秒后过期',
    `expires_date`  datetime comment 'access_token访问过期日期',
    `scope`         varchar(64) comment '固定值：all',
    `creator`       varchar(32) comment '创建人',
    `create_time`   datetime     not null default current_timestamp comment '创建时间',
    `editor`        varchar(32) comment '修改人',
    `update_time`   datetime     not null default current_timestamp on update current_timestamp comment '更新时间',
    primary key (`id`),
    unique key `uniq_app` (`app_key`, `company`)
) engine = innodb comment='聚水潭 授权信息';

drop table if exists jst_order;
create table `jst_order`
(
    `id`                   bigint       not null auto_increment comment '自增主键',
    `app_key`              varchar(64)  not null comment '聚水潭应用 key',
    `company`              varchar(255) not null comment '公司名称',
    `is_cod`               varchar(8) comment '是否货到付款',
    `l_id`                 varchar(256) comment '快递单号',
    `send_date`            datetime comment '发货日期',
    `pay_date`             datetime comment '支付时间',
    `freight`              varchar(64) comment '运费，保留两位小数，单位（元）',
    `receiver_address`     text comment '收货地址',
    `receiver_district`    varchar(64) comment '区',
    `wms_co_id`            varchar(64) comment '发货仓编号',
    `logistics_company`    varchar(64) comment '快递公司',
    `as_id`                varchar(64) comment '补发换货单对应的售后单号',
    `free_amount`          varchar(64) comment '抵扣金额',
    `shop_name`            varchar(64) comment '店铺名称',
    `question_type`        varchar(64) comment '问题类型，仅当问题订单时有效',
    `outer_pay_id`         varchar(128) comment '外部支付单号',
    `so_id`                varchar(64) comment '线上订单号，最长不超过 20;唯一',
    `type`                 varchar(64) comment '订单类型',
    `order_from`           varchar(64) comment '订单来源',
    `status`               varchar(64) comment '待付款：WaitPay；发货中：Delivering；被合并：Merged；异常：Question；被拆分：Split；等供销商|外仓发货：WaitOuterSent；已付款待审核：WaitConfirm；已客审待财审：WaitFConfirm；已发货：Sent；取消：Cancelled',
    `pay_amount`           varchar(64) comment '应付金额，保留两位小数，单位（元）',
    `shop_buyer_id`        text comment '买家昵称',
    `open_id`              varchar(128) comment '平台买家唯一值，仅支持抖音，快手，小红书',
    `shop_status`          varchar(64) comment '平台订单状态',
    `receiver_mobile`      text comment '手机',
    `receiver_phone`       varchar(128) comment '电话',
    `order_date`           datetime comment '下单时间',
    `question_desc`        varchar(64) comment '问题描述',
    `receiver_city`        varchar(64) comment '收件信息-市',
    `receiver_state`       varchar(64) comment '收件信息-省',
    `receiver_name`        mediumtext comment '收件信息-收件人',
    `o_id`                 bigint(20) not null comment 'ERP 内部订单号，唯一',
    `shop_id`              bigint(20) comment '店铺编号',
    `co_id`                bigint(20) comment '公司编号',
    `remark`               text comment '订单备注；卖家备注',
    `drp_co_id_from`       varchar(64) comment '分销商编号',
    `modified`             datetime comment '修改时间',
    `labels`               varchar(256) comment '多标签',
    `paid_amount`          varchar(64) comment '实际支付金额',
    `currency`             varchar(64) comment '币种',
    `buyer_message`        text comment '买家留言',
    `lc_id`                varchar(64) comment '物流公司编码',
    `invoice_title`        varchar(128) comment '发票抬头',
    `invoice_type`         varchar(64) comment '发票类型',
    `buyer_tax_no`         varchar(64) comment '发票税号',
    `creator_name`         varchar(64) comment '业务员',
    `plan_delivery_date`   datetime comment '计划发货时间',
    `node`                 text comment '线下备注',
    `receiver_town`        varchar(256) comment '收件信息-街道',
    `drp_co_id_to`         varchar(256) comment '供销商编号',
    `shop_site`            varchar(256) comment '店铺站点信息',
    `un_lid`               varchar(128) comment '国际物流单号',
    `end_time`             datetime comment '收货时间（仅限头条放心购、京东、拼多多）',
    `receiver_country`     varchar(32) comment '国家代码',
    `receiver_zip`         varchar(32) comment '邮编',
    `seller_flag`          int(11) comment '旗帜(1红旗，2黄旗，3绿旗，4蓝旗，5紫旗)）',
    `receiver_email`       varchar(128) comment '收货邮箱',
    `referrer_id`          varchar(64) comment '主播id',
    `referrer_name`        varchar(64) comment '主播名称',
    `created`              varchar(64) comment '订单创建时间',
    `pays`                 text comment '支付信息',
    `items`                mediumtext comment '购买商品列表',
    `skus`                 text comment '商品（商品总数.sku_id*qty',
    `f_weight`             varchar(64) comment '实称重量',
    `weight`               varchar(64) comment '重量',
    `ts`                   bigint(20) comment '数据库行版本号：https://docs.microsoft.com/zh-cn/sql/t-sql/data-types/rowversion-transact-sql?view=sql-server-ver16',
    `buyer_id`             varchar(64) comment '买家ID（系统根据shop_buy_id生成的）',
    `buyer_paid_amount`    varchar(64) comment '买家实付（仅限抖音，拼多多，京东平台订单）',
    `seller_income_amount` varchar(64) comment '卖家实收（仅限抖音，拼多多，京东平台订单）',
    `chosen_channel`       varchar(64) comment '实发快递渠道',
    `link_o_id`            varchar(64) comment '被合并被拆分的订单内部单号',
    `merge_so_id`          mediumtext comment '合并订单号',
    `shipment`             varchar(64) comment '买家指定物流',
    `sign_time`            varchar(64) comment '预计送达时间',
    `cb_finances`          varchar(64) comment '跨境线下订单财务数据',
    `f_freight`            varchar(16) comment '运费成本',
    `batch_id`             varchar(64) comment '批次号',
    `produced_date`        varchar(64) comment '生产日期',
    `tem_ext_data`         varchar(64) comment '订单明细扩展字段',
    `discount_rate`        varchar(64) comment 'discount_rate',
    `tag`                  text comment 'tag',
    `amount`               varchar(64) comment 'amount',
    `is_split`             varchar(64) comment 'is_split',
    `is_merge`             varchar(64) comment 'is_merge',
    `glasses`              varchar(64) comment 'glasses',
    `outer_as_id`          varchar(64) comment 'outer_as_id',
    `outer_so_id`          varchar(64) comment 'outer_so_id',
    `__raw_so_ids__`       text comment '__raw_so_ids__',
    `ext_datas`            text comment 'ext_datas',
    `raw_so_id`            varchar(64) comment 'raw_so_id',
    `drp_from`             varchar(64) comment 'drp_from',
    `drp_to`               varchar(64) comment 'drp_to',
    `sync_start_time`      datetime comment '同步元信息-修改起始时间',
    `sync_end_time`        datetime comment '同步元信息-修改结束时间',
    `sync_page_index`      int(11) comment '同步元信息-页数',
    `sync_page_size`       int(11) comment '同步元信息-条数',
    `creator`              varchar(32) comment '创建人',
    `create_time`          datetime     not null default current_timestamp comment '创建时间',
    `editor`               varchar(32) comment '修改人',
    `update_time`          datetime     not null default current_timestamp on update current_timestamp comment '更新时间',
    primary key (`id`),
    unique key `uniq_o_id` (`app_key`,`company`,`o_id`)
) engine = innodb comment='聚水潭 订单查询（非淘系订单查询）';