/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.constant;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.constant.Tag;
import cn.sliew.milky.common.constant.TagSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultTagSet
implements TagSet {
    private static final AtomicReferenceFieldUpdater<DefaultTagSet, Tag[]> TAGS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultTagSet.class, Tag[].class, "tags");
    private static final Tag[] EMPTY_TAGS = new Tag[0];
    private volatile Tag[] tags = EMPTY_TAGS;

    private static int searchTagByKey(Tag[] sortedTags, Tag key) {
        int low = 0;
        int high = sortedTags.length - 1;
        while (low <= high) {
            boolean searchRight;
            int mid = low + high >>> 1;
            Tag midVal = sortedTags[mid];
            if (midVal.equals(key)) {
                return mid;
            }
            int midValKeyId = midVal.id();
            int keyId = key.id();
            assert (midValKeyId != keyId);
            boolean bl = searchRight = midValKeyId < keyId;
            if (searchRight) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    private static void orderedCopyOnInsert(Tag[] sortedSrc, int srcLength, Tag[] copy, Tag toInsert) {
        int i;
        int id = toInsert.id();
        for (i = srcLength - 1; i >= 0; --i) {
            Tag tag = sortedSrc[i];
            assert (tag.id() != id);
            if (tag.id() < id) break;
            copy[i + 1] = sortedSrc[i];
        }
        copy[i + 1] = toInsert;
        int toCopy = i + 1;
        if (toCopy > 0) {
            System.arraycopy(sortedSrc, 0, copy, 0, toCopy);
        }
    }

    @Override
    public Collection<Tag> tags() {
        return Arrays.asList(this.tags);
    }

    @Override
    public void tag(Tag tag) {
        Ensures.checkNotNull(tag);
        while (true) {
            Tag[] tags;
            int index;
            if ((index = DefaultTagSet.searchTagByKey(tags = this.tags, tag)) >= 0) {
                continue;
            }
            int count = tags.length;
            Tag[] newTags = new Tag[count + 1];
            DefaultTagSet.orderedCopyOnInsert(tags, count, newTags, tag);
            if (TAGS_UPDATER.compareAndSet(this, tags, newTags)) break;
        }
    }

    @Override
    public boolean hasTag(Tag tag) {
        Ensures.checkNotNull(tag);
        return DefaultTagSet.searchTagByKey(this.tags, tag) >= 0;
    }
}

