/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.sharding.ClusterSharding$;
import org.apache.pekko.cluster.sharding.ClusterShardingGuardian;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.ShardCoordinator$ShardAllocationStrategy$;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tUt!B\u0013'\u0011\u0003\td!B\u001a'\u0011\u0003!\u0004B\u0002&\u0002\t\u0003\u0011\t\u0006C\u0004\u0003T\u0005!\tE!\u0016\t\u000f\tM\u0013\u0001\"\u0011\u0003`!9!\u0011N\u0001\u0005B\t-\u0004b\u0002B8\u0003\u0011\u0005#\u0011\u000f\u0004\u0005g\u0019\u0002!\t\u0003\u0005G\u000f\t\u0005\t\u0015!\u0003H\u0011\u0015Qu\u0001\"\u0001L\u0011\u001diuA1A\u0005\n9Ca!V\u0004!\u0002\u0013y\u0005bB\u0015\b\u0005\u0004%IA\u0016\u0005\u00077\u001e\u0001\u000b\u0011B,\t\u000fq;!\u0019!C\u0005;\"1ao\u0002Q\u0001\nyCqa^\u0004C\u0002\u0013%Q\f\u0003\u0004y\u000f\u0001\u0006IA\u0018\u0005\ts\u001eA)\u0019!C\u0005u\")1p\u0002C\u0001y\"11p\u0002C\u0001\u0003\u0017B\u0001\"!\u0017\b\t\u0003Q\u00131\f\u0005\u0007w\u001e!\t!a \t\rm<A\u0011AAF\u0011\u0019Yx\u0001\"\u0001\u0002\u0016\"11p\u0002C\u0001\u0003WCaa_\u0004\u0005\u0002\u0005U\u0006bBA_\u000f\u0011\u0005\u0011q\u0018\u0005\b\u0003{;A\u0011AAi\u0011\u001d\tIp\u0002C\u0005\u0003wDq!!0\b\t\u0003\u0011\t\u0001C\u0004\u0002>\u001e!\tA!\u0005\t\u000f\tmq\u0001\"\u0001\u0003\u001e!9!qF\u0004\u0005\u0002\tE\u0002b\u0002B\u001c\u000f\u0011\u0005!\u0011\b\u0005\b\u0005{9A\u0011\u0001B \u0011\u001d\u0011)e\u0002C\u0001\u0005\u000f\nqb\u00117vgR,'o\u00155be\u0012Lgn\u001a\u0006\u0003O!\n\u0001b\u001d5be\u0012Lgn\u001a\u0006\u0003S)\nqa\u00197vgR,'O\u0003\u0002,Y\u0005)\u0001/Z6l_*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0007\u0001\u0001\"AM\u0001\u000e\u0003\u0019\u0012qb\u00117vgR,'o\u00155be\u0012LgnZ\n\u0006\u0003UZ$1\n\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0007qz\u0014)D\u0001>\u0015\tq$&A\u0003bGR|'/\u0003\u0002A{\tYQ\t\u001f;f]NLwN\\%e!\t\u0011taE\u0002\bk\r\u0003\"\u0001\u0010#\n\u0005\u0015k$!C#yi\u0016t7/[8o\u0003\u0019\u0019\u0018p\u001d;f[B\u0011A\bS\u0005\u0003\u0013v\u00121#\u0012=uK:$W\rZ!di>\u00148+_:uK6\fa\u0001P5oSRtDCA!M\u0011\u00151\u0015\u00021\u0001H\u0003\rawnZ\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!KK\u0001\u0006KZ,g\u000e^\u0005\u0003)F\u0013a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004S#A,\u0011\u0005aKV\"\u0001\u0015\n\u0005iC#aB\"mkN$XM]\u0001\tG2,8\u000f^3sA\u00059!/Z4j_:\u001cX#\u00010\u0011\t}3\u0007n]\u0007\u0002A*\u0011\u0011MY\u0001\u000bG>t7-\u001e:sK:$(BA2e\u0003\u0011)H/\u001b7\u000b\u0003\u0015\fAA[1wC&\u0011q\r\u0019\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA5q\u001d\tQg\u000e\u0005\u0002lo5\tAN\u0003\u0002na\u00051AH]8pizJ!a\\\u001c\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_^\u0002\"\u0001\u0010;\n\u0005Ul$\u0001C!di>\u0014(+\u001a4\u0002\u0011I,w-[8og\u0002\nq\u0001\u001d:pq&,7/\u0001\u0005qe>D\u0018.Z:!\u0003!9W/\u0019:eS\u0006tW#A:\u0002\u000bM$\u0018M\u001d;\u0015\u001bMlx0!\u0003\u0002\u0014\u0005\u0015\u0012qFA!\u0011\u0015q8\u00031\u0001i\u0003!!\u0018\u0010]3OC6,\u0007bBA\u0001'\u0001\u0007\u00111A\u0001\fK:$\u0018\u000e^=Qe>\u00048\u000fE\u0002=\u0003\u000bI1!a\u0002>\u0005\u0015\u0001&o\u001c9t\u0011\u001d\tYa\u0005a\u0001\u0003\u001b\t\u0001b]3ui&twm\u001d\t\u0004e\u0005=\u0011bAA\tM\t92\t\\;ti\u0016\u00148\u000b[1sI&twmU3ui&twm\u001d\u0005\b\u0003+\u0019\u0002\u0019AA\f\u0003=)\u0007\u0010\u001e:bGR,e\u000e^5us&#\u0007\u0003BA\r\u0003?q1AMA\u000e\u0013\r\tiBJ\u0001\f'\"\f'\u000f\u001a*fO&|g.\u0003\u0003\u0002\"\u0005\r\"aD#yiJ\f7\r^#oi&$\u00180\u00133\u000b\u0007\u0005ua\u0005C\u0004\u0002(M\u0001\r!!\u000b\u0002\u001d\u0015DHO]1diNC\u0017M\u001d3JIB!\u0011\u0011DA\u0016\u0013\u0011\ti#a\t\u0003\u001d\u0015CHO]1diNC\u0017M\u001d3JI\"9\u0011\u0011G\nA\u0002\u0005M\u0012AE1mY>\u001c\u0017\r^5p]N#(/\u0019;fOf\u0004B!!\u000e\u0002<9\u0019!'a\u000e\n\u0007\u0005eb%\u0001\tTQ\u0006\u0014HmQ8pe\u0012Lg.\u0019;pe&!\u0011QHA \u0005]\u0019\u0006.\u0019:e\u00032dwnY1uS>t7\u000b\u001e:bi\u0016<\u0017PC\u0002\u0002:\u0019Bq!a\u0011\u0014\u0001\u0004\t)%\u0001\niC:$wJ\u001a4Ti>\u0004X*Z:tC\u001e,\u0007c\u0001\u001c\u0002H%\u0019\u0011\u0011J\u001c\u0003\u0007\u0005s\u0017\u0010F\u0007t\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013q\u000b\u0005\u0006}R\u0001\r\u0001\u001b\u0005\b\u0003\u0003!\u0002\u0019AA\u0002\u0011\u001d\t)\u0002\u0006a\u0001\u0003/Aq!a\n\u0015\u0001\u0004\tI\u0003C\u0004\u00022Q\u0001\r!a\r\t\u000f\u0005\rC\u00031\u0001\u0002F\u0005i\u0011N\u001c;fe:\fGn\u0015;beR$rb]A/\u0003?\n9'!\u001b\u0002l\u00055\u0014q\u000e\u0005\u0006}V\u0001\r\u0001\u001b\u0005\b\u0003\u0003)\u0002\u0019AA1!\u00191\u00141\r5\u0002\u0004%\u0019\u0011QM\u001c\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBA\u0006+\u0001\u0007\u0011Q\u0002\u0005\b\u0003+)\u0002\u0019AA\f\u0011\u001d\t9#\u0006a\u0001\u0003SAq!!\r\u0016\u0001\u0004\t\u0019\u0004C\u0004\u0002DU\u0001\r!!\u0012)\u0007U\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tIHK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003o\u00121\"\u00138uKJt\u0017\r\\!qSRY1/!!\u0002\u0004\u0006\u0015\u0015qQAE\u0011\u0015qh\u00031\u0001i\u0011\u001d\t\tA\u0006a\u0001\u0003\u0007Aq!a\u0003\u0017\u0001\u0004\ti\u0001C\u0004\u0002\u0016Y\u0001\r!a\u0006\t\u000f\u0005\u001db\u00031\u0001\u0002*QI1/!$\u0002\u0010\u0006E\u00151\u0013\u0005\u0006}^\u0001\r\u0001\u001b\u0005\b\u0003\u00039\u0002\u0019AA\u0002\u0011\u001d\t)b\u0006a\u0001\u0003/Aq!a\n\u0018\u0001\u0004\tI\u0003F\u0007t\u0003/\u000bI*a'\u0002\u001e\u0006\u001d\u0016\u0011\u0016\u0005\u0006}b\u0001\r\u0001\u001b\u0005\b\u0003\u0003A\u0002\u0019AA\u0002\u0011\u001d\tY\u0001\u0007a\u0001\u0003\u001bAq!a(\u0019\u0001\u0004\t\t+\u0001\tnKN\u001c\u0018mZ3FqR\u0014\u0018m\u0019;peB!\u0011\u0011DAR\u0013\u0011\t)+a\t\u0003!5+7o]1hK\u0016CHO]1di>\u0014\bbBA\u00191\u0001\u0007\u00111\u0007\u0005\b\u0003\u0007B\u0002\u0019AA#)%\u0019\u0018QVAX\u0003c\u000b\u0019\fC\u0003\u007f3\u0001\u0007\u0001\u000eC\u0004\u0002\u0002e\u0001\r!a\u0001\t\u000f\u0005-\u0011\u00041\u0001\u0002\u000e!9\u0011qT\rA\u0002\u0005\u0005FcB:\u00028\u0006e\u00161\u0018\u0005\u0006}j\u0001\r\u0001\u001b\u0005\b\u0003\u0003Q\u0002\u0019AA\u0002\u0011\u001d\tyJ\u0007a\u0001\u0003C\u000b!b\u001d;beR\u0004&o\u001c=z)%\u0019\u0018\u0011YAb\u0003\u001b\fy\rC\u0003\u007f7\u0001\u0007\u0001\u000eC\u0004\u0002Fn\u0001\r!a2\u0002\tI|G.\u001a\t\u0005m\u0005%\u0007.C\u0002\u0002L^\u0012aa\u00149uS>t\u0007bBA\u000b7\u0001\u0007\u0011q\u0003\u0005\b\u0003OY\u0002\u0019AA\u0015)-\u0019\u00181[Ak\u0003/\f)0a>\t\u000byd\u0002\u0019\u00015\t\u000f\u0005\u0015G\u00041\u0001\u0002H\"9\u0011\u0011\u001c\u000fA\u0002\u0005m\u0017A\u00033bi\u0006\u001cUM\u001c;feB)a'!3\u0002^B!\u0011q\\Ax\u001d\u0011\t\t/a;\u000f\t\u0005\r\u0018\u0011\u001e\b\u0005\u0003K\f9/D\u0001-\u0013\tYC&\u0003\u0002*U%\u0019\u0011Q\u001e\u0015\u0002\u001f\rcWo\u001d;feN+G\u000f^5oONLA!!=\u0002t\nQA)\u0019;b\u0007\u0016tG/\u001a:\u000b\u0007\u00055\b\u0006C\u0004\u0002\u0016q\u0001\r!a\u0006\t\u000f\u0005\u001dB\u00041\u0001\u0002*\u0005I\u0001O]8ys:\u000bW.\u001a\u000b\u0006Q\u0006u\u0018q \u0005\u0006}v\u0001\r\u0001\u001b\u0005\b\u00033l\u0002\u0019AAn)\u001d\u0019(1\u0001B\u0003\u0005\u001fAQA \u0010A\u0002!Dq!!2\u001f\u0001\u0004\u00119\u0001E\u0003\u0003\n\t-\u0001.D\u0001c\u0013\r\u0011iA\u0019\u0002\t\u001fB$\u0018n\u001c8bY\"9\u0011q\u0014\u0010A\u0002\u0005\u0005F#C:\u0003\u0014\tU!q\u0003B\r\u0011\u0015qx\u00041\u0001i\u0011\u001d\t)m\ba\u0001\u0005\u000fAq!!7 \u0001\u0004\u00119\u0001C\u0004\u0002 ~\u0001\r!!)\u0002\u001dMD\u0017M\u001d3UsB,g*Y7fgV\u0011!q\u0004\t\u0006\u0005C\u0011Y\u0003[\u0007\u0003\u0005GQAA!\n\u0003(\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0005S9\u0014AC2pY2,7\r^5p]&!!Q\u0006B\u0012\u0005\r\u0019V\r^\u0001\u0012O\u0016$8\u000b[1sIRK\b/\u001a(b[\u0016\u001cXC\u0001B\u001a!\u0015\u0011IA!\u000ei\u0013\r\u0011iCY\u0001\fg\"\f'\u000f\u001a*fO&|g\u000eF\u0002t\u0005wAQA \u0012A\u0002!\f\u0001c\u001d5be\u0012\u0014VmZ5p]B\u0013x\u000e_=\u0015\u000bM\u0014\tEa\u0011\t\u000by\u001c\u0003\u0019\u00015\t\u000f\u0005e7\u00051\u0001\u0002^\u0006qB-\u001a4bk2$8\u000b[1sI\u0006cGn\\2bi&|gn\u0015;sCR,w-\u001f\u000b\u0005\u0003g\u0011I\u0005C\u0004\u0002\f\u0011\u0002\r!!\u0004\u0011\u0007q\u0012i%C\u0002\u0003Pu\u00121#\u0012=uK:\u001c\u0018n\u001c8JIB\u0013xN^5eKJ$\u0012!M\u0001\u0004O\u0016$HcA!\u0003X!1ai\u0001a\u0001\u00053\u00022\u0001\u0010B.\u0013\r\u0011i&\u0010\u0002\f\u0003\u000e$xN]*zgR,W\u000eF\u0002B\u0005CBaA\u0012\u0003A\u0002\t\r\u0004c\u0001\u001f\u0003f%\u0019!qM\u001f\u00035\rc\u0017m]:jG\u0006\u001bGo\u001c:TsN$X-\u001c)s_ZLG-\u001a:\u0002\r1|wn[;q+\t\u0011iG\u0004\u00023\u0001\u0005y1M]3bi\u0016,\u0005\u0010^3og&|g\u000eF\u0002B\u0005gBQA\u0012\u0004A\u0002\u001d\u0003")
public class ClusterSharding
implements Extension {
    private ActorRef guardian;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Cluster cluster;
    private final ConcurrentHashMap<String, ActorRef> regions;
    private final ConcurrentHashMap<String, ActorRef> proxies;
    private volatile boolean bitmap$0;

    public static ClusterSharding createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterSharding$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterSharding$ lookup() {
        return ClusterSharding$.MODULE$.lookup();
    }

    public static ClusterSharding get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterSharding$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterSharding get(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterSharding$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.apply(actorSystem);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    private ConcurrentHashMap<String, ActorRef> regions() {
        return this.regions;
    }

    private ConcurrentHashMap<String, ActorRef> proxies() {
        return this.proxies;
    }

    private ActorRef guardian$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                String guardianName = this.system.settings().config().getString("pekko.cluster.sharding.guardian-name");
                String dispatcher = this.system.settings().config().getString("pekko.cluster.sharding.use-dispatcher");
                this.guardian = this.system.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(ClusterShardingGuardian.class)).withDispatcher(dispatcher), guardianName);
                this.bitmap$0 = true;
            }
        }
        return this.guardian;
    }

    private ActorRef guardian() {
        if (!this.bitmap$0) {
            return this.guardian$lzycompute();
        }
        return this.guardian;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable & scala.Serializable)x$1 -> entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    @InternalApi
    public ActorRef internalStart(String typeName, Function1<String, Props> entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        String string = settings.stateStoreMode();
        String string2 = ClusterShardingSettings$.MODULE$.StateStoreModePersistence();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log().warning("Cluster Sharding has been set to use the deprecated `persistence` state store mode.");
        }
        if (settings.shouldHostShard(this.cluster())) {
            ActorRef actorRef = this.regions().get(typeName);
            if (actorRef == null) {
                Timeout timeout = this.system.settings().CreationTimeout();
                ClusterShardingGuardian.Start startMsg = new ClusterShardingGuardian.Start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
                ActorRef qual$1 = package$.MODULE$.ask(this.guardian());
                ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)startMsg);
                ActorRef shardRegion = ((ClusterShardingGuardian.Started)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)startMsg, timeout, x$3).mapTo(ClassTag$.MODULE$.apply(ClusterShardingGuardian.Started.class)), (Duration)timeout.duration())).shardRegion();
                this.regions().put(typeName, shardRegion);
                return shardRegion;
            }
            return actorRef;
        }
        this.log().debug("Starting Shard Region Proxy [{}] (no actors will be hosted on this node)...", (Object)typeName);
        return this.startProxy(typeName, settings.role(), (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable & scala.Serializable)x$2 -> entityProps, settings, (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (this.messageExtractor$1.entityId(x1) != null) {
                    return (B1)new Tuple2((Object)this.messageExtractor$1.entityId(x1), this.messageExtractor$1.entityMessage(x1));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return this.messageExtractor$1.entityId(x1) != null;
            }
            {
                this.messageExtractor$1 = messageExtractor$1;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg), allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, messageExtractor, allocationStrategy, (Object)PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, ShardRegion.MessageExtractor messageExtractor) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Option<String> role, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.startProxy(typeName, role, (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    public ActorRef startProxy(String typeName, Option<String> role, Option<String> dataCenter, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ActorRef actorRef = this.proxies().get(this.proxyName(typeName, dataCenter));
        if (actorRef == null) {
            Timeout timeout = this.system.settings().CreationTimeout();
            ClusterShardingSettings settings = ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system).withRole(role);
            ClusterShardingGuardian.StartProxy startMsg = new ClusterShardingGuardian.StartProxy(typeName, dataCenter, settings, extractEntityId, extractShardId);
            ActorRef qual$1 = package$.MODULE$.ask(this.guardian());
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)startMsg);
            ActorRef shardRegion = ((ClusterShardingGuardian.Started)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)startMsg, timeout, x$3).mapTo(ClassTag$.MODULE$.apply(ClusterShardingGuardian.Started.class)), (Duration)timeout.duration())).shardRegion();
            this.proxies().put(this.proxyName(typeName, dataCenter), shardRegion);
            return shardRegion;
        }
        return actorRef;
    }

    private String proxyName(String typeName, Option<String> dataCenter) {
        if (None$.MODULE$.equals(dataCenter)) {
            return new StringBuilder(5).append(typeName).append("Proxy").toString();
        }
        if (dataCenter instanceof Some) {
            String t = (String)((Some)dataCenter).value();
            return new StringBuilder(6).append(typeName).append("Proxy").append("-").append(t).toString();
        }
        throw new MatchError(dataCenter);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, role, Optional.empty(), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, Optional<String> dataCenter, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, (Option<String>)Option$.MODULE$.apply(role.orElse(null)), (Option<String>)Option$.MODULE$.apply(dataCenter.orElse(null)), (PartialFunction<Object, Tuple2<String, Object>>)new scala.Serializable(null, messageExtractor){
            public static final long serialVersionUID = 0L;
            private final ShardRegion.MessageExtractor messageExtractor$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (this.messageExtractor$2.entityId(x1) != null) {
                    return (B1)new Tuple2((Object)this.messageExtractor$2.entityId(x1), this.messageExtractor$2.entityMessage(x1));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return this.messageExtractor$2.entityId(x1) != null;
            }
            {
                this.messageExtractor$2 = messageExtractor$2;
            }
        }, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)msg -> messageExtractor.shardId(msg));
    }

    public scala.collection.immutable.Set<String> shardTypeNames() {
        return ((TraversableOnce)package.JavaConverters$.MODULE$.asScalaSetConverter(this.regions().keySet()).asScala()).toSet();
    }

    public Set<String> getShardTypeNames() {
        return this.regions().keySet();
    }

    public ActorRef shardRegion(String typeName) {
        ActorRef actorRef = this.regions().get(typeName);
        if (actorRef == null) {
            ActorRef actorRef2 = this.proxies().get(this.proxyName(typeName, (Option<String>)None$.MODULE$));
            if (actorRef2 == null) {
                throw new IllegalStateException(new StringBuilder(54).append("Shard type [").append(typeName).append("] must be started first. Started ").append(this.regions().keySet()).append(" proxies ").append(this.proxies().keySet()).toString());
            }
            return actorRef2;
        }
        return actorRef;
    }

    public ActorRef shardRegionProxy(String typeName, String dataCenter) {
        ActorRef actorRef = this.proxies().get(this.proxyName(typeName, (Option<String>)new Some((Object)dataCenter)));
        if (actorRef == null) {
            throw new IllegalStateException(new StringBuilder(35).append("Shard type [").append(typeName).append("] must be started first").toString());
        }
        return actorRef;
    }

    public ShardCoordinator.ShardAllocationStrategy defaultShardAllocationStrategy(ClusterShardingSettings settings) {
        if (settings.tuningParameters().leastShardAllocationAbsoluteLimit() > 0) {
            int absoluteLimit = settings.tuningParameters().leastShardAllocationAbsoluteLimit();
            double relativeLimit = settings.tuningParameters().leastShardAllocationRelativeLimit();
            return ShardCoordinator$ShardAllocationStrategy$.MODULE$.leastShardAllocationStrategy(absoluteLimit, relativeLimit);
        }
        int threshold = settings.tuningParameters().leastShardAllocationRebalanceThreshold();
        int maxSimultaneousRebalance = settings.tuningParameters().leastShardAllocationMaxSimultaneousRebalance();
        return new ShardCoordinator.LeastShardAllocationStrategy(threshold, maxSimultaneousRebalance);
    }

    public ClusterSharding(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterSharding.class, LogSource$.MODULE$.fromAnyClass());
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)system);
        this.regions = new ConcurrentHashMap();
        this.proxies = new ConcurrentHashMap();
    }
}

