/*
 * Decompiled with CFR 0.152.
 */
package slick.jdbc;

import com.typesafe.config.Config;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.Driver;
import javax.sql.DataSource;
import scala.Option;
import scala.reflect.ScalaSignature;
import slick.jdbc.ConnectionPreparer;
import slick.jdbc.DataSourceJdbcDataSource$;
import slick.jdbc.JdbcDataSource;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\n\u0014\u0001aA\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\t_\u0001\u0011\t\u0011)A\u0005O!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u00033\u0011!I\u0004A!b\u0001\n\u0003Q\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\t\u0003!Q1A\u0005\u0002\rC\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002)\t\u000bU\u0003A\u0011\u0001,\t\u000b]\u0003A\u0011\u0001-\b\u000bq\u001b\u0002\u0012A/\u0007\u000bI\u0019\u0002\u0012\u00010\t\u000b!sA\u0011A3\t\u000b\u0019tA\u0011A4\t\u0013\u0005]a\"%A\u0005\u0002\u0005e!\u0001\u0007#bi\u0006\u001cv.\u001e:dK*#'m\u0019#bi\u0006\u001cv.\u001e:dK*\u0011A#F\u0001\u0005U\u0012\u00147MC\u0001\u0017\u0003\u0015\u0019H.[2l\u0007\u0001\u00192\u0001A\r\"!\tQr$D\u0001\u001c\u0015\taR$\u0001\u0003mC:<'\"\u0001\u0010\u0002\t)\fg/Y\u0005\u0003Am\u0011aa\u00142kK\u000e$\bC\u0001\u0012$\u001b\u0005\u0019\u0012B\u0001\u0013\u0014\u00059QEMY2ECR\f7k\\;sG\u0016\f!\u0001Z:\u0016\u0003\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0007M\fHNC\u0001-\u0003\u0015Q\u0017M^1y\u0013\tq\u0013F\u0001\u0006ECR\f7k\\;sG\u0016\f1\u0001Z:!\u0003MYW-\u001a9BY&4XmQ8o]\u0016\u001cG/[8o+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$a\u0002\"p_2,\u0017M\\\u0001\u0015W\u0016,\u0007/\u00117jm\u0016\u001cuN\u001c8fGRLwN\u001c\u0011\u0002\u001d5\f\u0007pQ8o]\u0016\u001cG/[8ogV\t1\bE\u00024yyJ!!\u0010\u001b\u0003\r=\u0003H/[8o!\t\u0019t(\u0003\u0002Ai\t\u0019\u0011J\u001c;\u0002\u001f5\f\u0007pQ8o]\u0016\u001cG/[8og\u0002\n!cY8o]\u0016\u001cG/[8o!J,\u0007/\u0019:feV\tA\t\u0005\u0002#\u000b&\u0011ai\u0005\u0002\u0013\u0007>tg.Z2uS>t\u0007K]3qCJ,'/A\nd_:tWm\u0019;j_:\u0004&/\u001a9be\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0006\u0015.cUJ\u0014\t\u0003E\u0001AQ!J\u0005A\u0002\u001dBQ\u0001M\u0005A\u0002IBQ!O\u0005A\u0002mBqAQ\u0005\u0011\u0002\u0003\u0007A)A\rpa\u0016tW\rZ&fKB\fE.\u001b<f\u0007>tg.Z2uS>t\u0007CA)T\u001b\u0005\u0011&B\u0001\u0016\u001e\u0013\t!&K\u0001\u0006D_:tWm\u0019;j_:\f\u0001c\u0019:fCR,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0003A\u000bQa\u00197pg\u0016$\u0012!\u0017\t\u0003giK!a\u0017\u001b\u0003\tUs\u0017\u000e^\u0001\u0019\t\u0006$\u0018mU8ve\u000e,'\n\u001a2d\t\u0006$\u0018mU8ve\u000e,\u0007C\u0001\u0012\u000f'\rqqL\u0019\t\u0003g\u0001L!!\u0019\u001b\u0003\r\u0005s\u0017PU3g!\t\u00113-\u0003\u0002e'\t)\"\n\u001a2d\t\u0006$\u0018mU8ve\u000e,g)Y2u_JLH#A/\u0002\u0013\u0019|'oQ8oM&<GC\u0002&iif\fi\u0001C\u0003j!\u0001\u0007!.A\u0001d!\tY'/D\u0001m\u0015\tig.\u0001\u0004d_:4\u0017n\u001a\u0006\u0003_B\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002c\u0006\u00191m\\7\n\u0005Md'AB\"p]\u001aLw\rC\u0003v!\u0001\u0007a/\u0001\u0004ee&4XM\u001d\t\u0003#^L!\u0001\u001f*\u0003\r\u0011\u0013\u0018N^3s\u0011\u0015Q\b\u00031\u0001|\u0003\u0011q\u0017-\\3\u0011\u0007q\f9AD\u0002~\u0003\u0007\u0001\"A \u001b\u000e\u0003}T1!!\u0001\u0018\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0001\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\u0003\u0003\rM#(/\u001b8h\u0015\r\t)\u0001\u000e\u0005\b\u0003\u001f\u0001\u0002\u0019AA\t\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0011\u0007i\t\u0019\"C\u0002\u0002\u0016m\u00111b\u00117bgNdu.\u00193fe\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!a\u0007+\u0007\u0011\u000bib\u000b\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!C;oG\",7m[3e\u0015\r\tI\u0003N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0017\u0003G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DataSourceJdbcDataSource
implements JdbcDataSource {
    private final DataSource ds;
    private final boolean keepAliveConnection;
    private final Option<Object> maxConnections;
    private final ConnectionPreparer connectionPreparer;
    private Connection openedKeepAliveConnection;

    public static ConnectionPreparer $lessinit$greater$default$4() {
        return DataSourceJdbcDataSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static DataSourceJdbcDataSource forConfig(Config config, Driver driver, String string, ClassLoader classLoader) {
        return DataSourceJdbcDataSource$.MODULE$.forConfig(config, driver, string, classLoader);
    }

    public DataSource ds() {
        return this.ds;
    }

    public boolean keepAliveConnection() {
        return this.keepAliveConnection;
    }

    @Override
    public Option<Object> maxConnections() {
        return this.maxConnections;
    }

    public ConnectionPreparer connectionPreparer() {
        return this.connectionPreparer;
    }

    @Override
    public Connection createConnection() {
        if (this.keepAliveConnection()) {
            synchronized (this) {
                if (this.openedKeepAliveConnection == null) {
                    this.openedKeepAliveConnection = this.ds().getConnection();
                }
            }
        }
        Connection c = this.ds().getConnection();
        if (this.connectionPreparer() != null) {
            this.connectionPreparer().apply(c);
        }
        return c;
    }

    @Override
    public void close() {
        try {
            if (this.keepAliveConnection() && this.openedKeepAliveConnection != null) {
                this.openedKeepAliveConnection.close();
            }
        }
        catch (Throwable throwable) {
            DataSource dataSource = this.ds();
            if (dataSource instanceof Closeable) {
                ((Closeable)((Object)dataSource)).close();
            }
            throw throwable;
        }
        DataSource dataSource = this.ds();
        if (dataSource instanceof Closeable) {
            ((Closeable)((Object)dataSource)).close();
            return;
        }
    }

    public DataSourceJdbcDataSource(DataSource ds, boolean keepAliveConnection, Option<Object> maxConnections, ConnectionPreparer connectionPreparer) {
        this.ds = ds;
        this.keepAliveConnection = keepAliveConnection;
        this.maxConnections = maxConnections;
        this.connectionPreparer = connectionPreparer;
        this.openedKeepAliveConnection = null;
    }
}

