/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.upload.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.upload.FileUpload;
import jodd.io.upload.MultipartRequestInputStream;

public class MemoryFileUpload
extends FileUpload {
    protected byte[] data;

    MemoryFileUpload(MultipartRequestInputStream input, int maxFileSize) {
        super(input, maxFileSize);
    }

    @Override
    public byte[] getFileContent() {
        return this.data;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public InputStream getFileInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public void processStream() throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.size = 0;
        if (this.maxFileSize == -1) {
            this.size += this.input.copyAll(out);
        } else {
            this.size += this.input.copyMax(out, this.maxFileSize + 1);
            if (this.size > this.maxFileSize) {
                this.fileTooBig = true;
                this.valid = false;
                this.input.skipToBoundary();
                return;
            }
        }
        this.data = out.toByteArray();
        this.size = this.data.length;
        this.valid = true;
    }
}

