/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.connection.ServiceManager;
import org.redisson.misc.WrappedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueueTransferTask {
    private static final Logger log = LoggerFactory.getLogger(QueueTransferTask.class);
    private int usage = 1;
    private final AtomicReference<TimeoutTask> lastTimeout = new AtomicReference();
    private final ServiceManager serviceManager;
    private final WrappedLock lock = new WrappedLock();
    private int messageListenerId;
    private int statusListenerId;

    public QueueTransferTask(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void incUsage() {
        ++this.usage;
    }

    public int decUsage() {
        --this.usage;
        return this.usage;
    }

    public void start() {
        RTopic schedulerTopic = this.getTopic();
        this.statusListenerId = schedulerTopic.addListener(new BaseStatusListener(){

            @Override
            public void onSubscribe(String channel) {
                QueueTransferTask.this.pushTask();
            }
        });
        this.messageListenerId = schedulerTopic.addListener(Long.class, new MessageListener<Long>(){

            @Override
            public void onMessage(CharSequence channel, Long startTime) {
                QueueTransferTask.this.scheduleTask(startTime);
            }
        });
    }

    public void stop() {
        RTopic schedulerTopic = this.getTopic();
        schedulerTopic.removeListener(this.messageListenerId);
        schedulerTopic.removeListener(this.statusListenerId);
    }

    private void scheduleTask(Long startTime) {
        long delay;
        TimeoutTask oldTimeout = this.lastTimeout.get();
        if (startTime == null) {
            return;
        }
        if (oldTimeout != null) {
            oldTimeout.getTask().cancel();
        }
        if ((delay = startTime - System.currentTimeMillis()) > 10L) {
            Timeout timeout = this.serviceManager.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    QueueTransferTask.this.pushTask();
                    TimeoutTask currentTimeout = (TimeoutTask)QueueTransferTask.this.lastTimeout.get();
                    if (currentTimeout.getTask() == timeout) {
                        QueueTransferTask.this.lastTimeout.compareAndSet(currentTimeout, null);
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
            if (!this.lastTimeout.compareAndSet(oldTimeout, new TimeoutTask(startTime, timeout))) {
                timeout.cancel();
            }
        } else {
            this.pushTask();
        }
    }

    protected abstract RTopic getTopic();

    protected abstract RFuture<Long> pushTaskAsync();

    private void pushTask() {
        RFuture<Long> startTimeFuture = this.pushTaskAsync();
        startTimeFuture.whenComplete((res, e) -> {
            if (e != null) {
                if (e instanceof RedissonShutdownException) {
                    return;
                }
                log.error(e.getMessage(), e);
                this.scheduleTask(System.currentTimeMillis() + 5000L);
                return;
            }
            if (res != null) {
                this.scheduleTask((Long)res);
            }
        });
    }

    public WrappedLock getLock() {
        return this.lock;
    }

    public static class TimeoutTask {
        private final long startTime;
        private final Timeout task;

        public TimeoutTask(long startTime, Timeout task) {
            this.startTime = startTime;
            this.task = task;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Timeout getTask() {
            return this.task;
        }
    }
}

