/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.spring.util;

import cn.sliew.carp.module.security.spring.authentication.CarpUserDetail;
import cn.sliew.carp.module.security.spring.util.CookieUtil;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class SecurityUtil
extends Enum<SecurityUtil> {
    private static final /* synthetic */ SecurityUtil[] $VALUES;

    public static SecurityUtil[] values() {
        return (SecurityUtil[])$VALUES.clone();
    }

    public static SecurityUtil valueOf(String name) {
        return Enum.valueOf(SecurityUtil.class, name);
    }

    public static CarpUserDetail getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!ObjectUtils.isEmpty((Object)authentication) && authentication.getPrincipal() instanceof CarpUserDetail) {
            return (CarpUserDetail)authentication.getPrincipal();
        }
        return null;
    }

    public static String getCurrentUserName() {
        CarpUserDetail currentUser = SecurityUtil.getCurrentUser();
        if (currentUser != null) {
            return currentUser.getUsername();
        }
        return null;
    }

    public static Optional<Long> getCurrentUserId() {
        CarpUserDetail userDetailInfo = SecurityUtil.getCurrentUser();
        if (userDetailInfo != null) {
            return Optional.of(userDetailInfo.getUser().getId());
        }
        return Optional.empty();
    }

    public static String resolveToken(HttpServletRequest request) {
        String headerToken = request.getHeader("u_token");
        if (StringUtils.hasText((String)headerToken)) {
            return headerToken;
        }
        String paramToken = request.getParameter("u_token");
        if (StringUtils.hasText((String)paramToken)) {
            return paramToken;
        }
        Cookie cookie = CookieUtil.findCookieByName(request, "u_token");
        if (cookie != null && StringUtils.hasText((String)cookie.getValue())) {
            return cookie.getValue();
        }
        return null;
    }

    private static /* synthetic */ SecurityUtil[] $values() {
        return new SecurityUtil[0];
    }

    static {
        $VALUES = SecurityUtil.$values();
    }
}

