/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.cloud.context.named.NamedContextFactory;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.lang.Nullable;

public class FeignClientFactory
extends NamedContextFactory<FeignClientSpecification> {
    public FeignClientFactory() {
        this(new HashMap<String, ApplicationContextInitializer<GenericApplicationContext>>());
    }

    public FeignClientFactory(Map<String, ApplicationContextInitializer<GenericApplicationContext>> applicationContextInitializers) {
        super(FeignClientsConfiguration.class, "spring.cloud.openfeign", "spring.cloud.openfeign.client.name", applicationContextInitializers);
    }

    @Nullable
    public <T> T getInstanceWithoutAncestors(String name, Class<T> type) {
        try {
            return (T)BeanFactoryUtils.beanOfType((ListableBeanFactory)this.getContext(name), type);
        }
        catch (BeansException ex) {
            return null;
        }
    }

    @Nullable
    public <T> Map<String, T> getInstancesWithoutAncestors(String name, Class<T> type) {
        return this.getContext(name).getBeansOfType(type);
    }

    public <T> T getInstance(String contextName, String beanName, Class<T> type) {
        return (T)this.getContext(contextName).getBean(beanName, type);
    }

    public FeignClientFactory withApplicationContextInitializers(Map<String, Object> applicationContextInitializers) {
        HashMap<String, ApplicationContextInitializer<GenericApplicationContext>> convertedInitializers = new HashMap<String, ApplicationContextInitializer<GenericApplicationContext>>();
        applicationContextInitializers.keySet().forEach(contextId -> convertedInitializers.put((String)contextId, (ApplicationContextInitializer<GenericApplicationContext>)((ApplicationContextInitializer)applicationContextInitializers.get(contextId))));
        return new FeignClientFactory(convertedInitializers);
    }
}

