/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableSpringEncoder
implements Encoder {
    private final Encoder delegate;
    private String pageParameter = "page";
    private String sizeParameter = "size";
    private String sortParameter = "sort";

    public PageableSpringEncoder(Encoder delegate) {
        this.delegate = delegate;
    }

    public void setPageParameter(String pageParameter) {
        this.pageParameter = pageParameter;
    }

    public void setSizeParameter(String sizeParameter) {
        this.sizeParameter = sizeParameter;
    }

    public void setSortParameter(String sortParameter) {
        this.sortParameter = sortParameter;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (this.supports(object)) {
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                if (pageable.isPaged()) {
                    template.query(this.pageParameter, new String[]{String.valueOf(pageable.getPageNumber())});
                    template.query(this.sizeParameter, new String[]{String.valueOf(pageable.getPageSize())});
                }
                if (pageable.getSort() != null) {
                    this.applySort(template, pageable.getSort());
                }
            } else if (object instanceof Sort) {
                Sort sort = (Sort)object;
                this.applySort(template, sort);
            }
        } else if (this.delegate != null) {
            this.delegate.encode(object, bodyType, template);
        } else {
            throw new EncodeException("PageableSpringEncoder does not support the given object " + object.getClass() + " and no delegate was provided for fallback!");
        }
    }

    private void applySort(RequestTemplate template, Sort sort) {
        ArrayList<CallSite> sortQueries;
        Collection existingSorts = (Collection)template.queries().get("sort");
        ArrayList<CallSite> arrayList = sortQueries = existingSorts != null ? new ArrayList<CallSite>(existingSorts) : new ArrayList();
        if (!this.sortParameter.equals("sort") && (existingSorts = (Collection)template.queries().get(this.sortParameter)) != null) {
            sortQueries.addAll(existingSorts);
        }
        for (Sort.Order order : sort) {
            sortQueries.add((CallSite)((Object)(order.getProperty() + "%2C" + order.getDirection())));
        }
        if (!sortQueries.isEmpty()) {
            template.query(this.sortParameter, sortQueries);
        }
    }

    protected boolean supports(Object object) {
        return object instanceof Pageable || object instanceof Sort;
    }
}

