/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.restart.PauseHandler;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.core.Pausable;
import org.springframework.integration.monitor.IntegrationMBeanExporter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={IntegrationMBeanExporter.class})
class RestartEndpointWithIntegrationConfiguration {
    private IntegrationMBeanExporter exporter;

    RestartEndpointWithIntegrationConfiguration(@Autowired(required=false) IntegrationMBeanExporter exporter) {
        this.exporter = exporter;
    }

    @Bean
    public PauseHandler integrationPauseHandler(ObjectProvider<Pausable> pausables) {
        return new IntegrationPauseHandler(pausables.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnMissingBean
    public RestartEndpoint restartEndpoint() {
        RestartEndpoint endpoint = new RestartEndpoint();
        if (this.exporter != null) {
            endpoint.setIntegrationMBeanExporter(this.exporter);
        }
        return endpoint;
    }

    private class IntegrationPauseHandler
    implements PauseHandler {
        private List<Pausable> pausables = new ArrayList<Pausable>();

        IntegrationPauseHandler(List<Pausable> pausables) {
            this.pausables.addAll(pausables);
        }

        @Override
        public void pause() {
            for (Pausable pausable : this.pausables) {
                pausable.pause();
            }
        }

        @Override
        public void resume() {
            int i = this.pausables.size();
            while (i-- > 0) {
                this.pausables.get(i).resume();
            }
        }
    }
}

