/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Request;
import feign.RequestTemplate;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.openfeign.loadbalancer.LoadBalancerFeignRequestTransformer;

public class XForwardedHeadersTransformer
implements LoadBalancerFeignRequestTransformer {
    private final ReactiveLoadBalancer.Factory<ServiceInstance> factory;

    public XForwardedHeadersTransformer(ReactiveLoadBalancer.Factory<ServiceInstance> factory) {
        this.factory = factory;
    }

    @Override
    public Request transformRequest(Request request, ServiceInstance instance) {
        if (instance == null) {
            return request;
        }
        LoadBalancerProperties.XForwarded xForwarded = this.factory.getProperties(instance.getServiceId()).getXForwarded();
        if (xForwarded.isEnabled()) {
            HashMap<String, Set<String>> headers = new HashMap<String, Set<String>>(request.headers());
            URI uri = URI.create(request.url());
            String xForwardedHost = uri.getHost();
            String xForwardedProto = uri.getScheme();
            headers.put("X-Forwarded-Host", Collections.singleton(xForwardedHost));
            headers.put("X-Forwarded-Proto", Collections.singleton(xForwardedProto));
            request = Request.create((Request.HttpMethod)request.httpMethod(), (String)request.url(), headers, (byte[])request.body(), (Charset)request.charset(), (RequestTemplate)request.requestTemplate());
        }
        return request;
    }
}

