/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.LeastFrequentlyUsedReplacementPolicy;
import org.apache.pekko.cluster.sharding.internal.LeastRecentlyUsedReplacementPolicy;
import org.apache.pekko.cluster.sharding.internal.MostRecentlyUsedReplacementPolicy;
import org.apache.pekko.cluster.sharding.internal.NoActiveEntities$;
import org.apache.pekko.cluster.sharding.internal.SegmentedLeastRecentlyUsedReplacementPolicy;
import scala.collection.immutable.Seq;

@InternalApi
public final class ActiveEntities$ {
    public static ActiveEntities$ MODULE$;

    static {
        new ActiveEntities$();
    }

    public ActiveEntities apply(ClusterShardingSettings.PassivationStrategy strategy, boolean idleEnabled) {
        if (strategy instanceof ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy) {
            Seq<Object> segmented = ((ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy)strategy).segmented();
            if (segmented.isEmpty()) {
                return new LeastRecentlyUsedReplacementPolicy(0);
            }
            return new SegmentedLeastRecentlyUsedReplacementPolicy(0, segmented, idleEnabled);
        }
        if (strategy instanceof ClusterShardingSettings.MostRecentlyUsedPassivationStrategy) {
            return new MostRecentlyUsedReplacementPolicy(0);
        }
        if (strategy instanceof ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy) {
            boolean dynamicAging = ((ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy)strategy).dynamicAging();
            return new LeastFrequentlyUsedReplacementPolicy(0, dynamicAging, idleEnabled);
        }
        return NoActiveEntities$.MODULE$;
    }

    private ActiveEntities$() {
        MODULE$ = this;
    }
}

