/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.parser;

import com.baomidou.mybatisplus.extension.parser.JsqlParserFunction;
import com.baomidou.mybatisplus.extension.parser.cache.JsqlParseCache;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;

public class JsqlParserGlobal {
    public static final int DEFAULT_THREAD_SIZE = (Runtime.getRuntime().availableProcessors() + 1) / 2;
    public static ExecutorService executorService = new ThreadPoolExecutor(DEFAULT_THREAD_SIZE, DEFAULT_THREAD_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread thread = new Thread(r);
        thread.setName("mybatis-plus-jsqlParser-" + thread.getId());
        thread.setDaemon(true);
        return thread;
    });
    private static JsqlParserFunction<String, Statement> parserSingleFunc = sql -> CCJSqlParserUtil.parse((String)sql, (ExecutorService)executorService, null);
    private static JsqlParserFunction<String, Statements> parserMultiFunc = sql -> CCJSqlParserUtil.parseStatements((String)sql, (ExecutorService)executorService, null);
    private static JsqlParseCache jsqlParseCache;

    public static Statement parse(String sql) throws JSQLParserException {
        if (jsqlParseCache == null) {
            return parserSingleFunc.apply(sql);
        }
        Statement statement = jsqlParseCache.getStatement(sql);
        if (statement == null) {
            statement = parserSingleFunc.apply(sql);
            jsqlParseCache.putStatement(sql, statement);
        }
        return statement;
    }

    public static Statements parseStatements(String sql) throws JSQLParserException {
        if (jsqlParseCache == null) {
            return parserMultiFunc.apply(sql);
        }
        Statements statements = jsqlParseCache.getStatements(sql);
        if (statements == null) {
            statements = parserMultiFunc.apply(sql);
            jsqlParseCache.putStatements(sql, statements);
        }
        return statements;
    }

    public static void setParserSingleFunc(JsqlParserFunction<String, Statement> parserSingleFunc) {
        JsqlParserGlobal.parserSingleFunc = parserSingleFunc;
    }

    public static void setParserMultiFunc(JsqlParserFunction<String, Statements> parserMultiFunc) {
        JsqlParserGlobal.parserMultiFunc = parserMultiFunc;
    }

    public static void setJsqlParseCache(JsqlParseCache jsqlParseCache) {
        JsqlParserGlobal.jsqlParseCache = jsqlParseCache;
    }
}

