/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusOutputFormat;
import org.springframework.lang.Nullable;

@WebEndpoint(id="prometheus")
public class PrometheusScrapeEndpoint {
    private static final int METRICS_SCRAPE_CHARS_EXTRA = 1024;
    private final PrometheusRegistry prometheusRegistry;
    private volatile int nextMetricsScrapeSize = 16;

    public PrometheusScrapeEndpoint(PrometheusRegistry prometheusRegistry) {
        this.prometheusRegistry = prometheusRegistry;
    }

    @ReadOperation(producesFrom=PrometheusOutputFormat.class)
    public WebEndpointResponse<byte[]> scrape(PrometheusOutputFormat format, @Nullable Set<String> includedNames) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(this.nextMetricsScrapeSize);
            MetricSnapshots metricSnapshots = includedNames != null ? this.prometheusRegistry.scrape(includedNames::contains) : this.prometheusRegistry.scrape();
            format.write(outputStream, metricSnapshots);
            byte[] content = outputStream.toByteArray();
            this.nextMetricsScrapeSize = content.length + 1024;
            return new WebEndpointResponse<byte[]>(content, format);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Writing metrics failed", ex);
        }
    }
}

