/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.HttpConnectionIdleTimeoutBidi$;
import org.apache.pekko.http.impl.engine.HttpIdleTimeoutException;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$GoAwayFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameLogger$;
import org.apache.pekko.http.impl.engine.http2.Http2$;
import org.apache.pekko.http.impl.engine.http2.Http2Blueprint;
import org.apache.pekko.http.impl.engine.http2.Http2ClientDemux;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$INTERNAL_ERROR$;
import org.apache.pekko.http.impl.engine.http2.Http2ServerDemux;
import org.apache.pekko.http.impl.engine.http2.Http2SubStream;
import org.apache.pekko.http.impl.engine.http2.RequestParsing$;
import org.apache.pekko.http.impl.engine.http2.RequestRendering;
import org.apache.pekko.http.impl.engine.http2.ResponseRendering;
import org.apache.pekko.http.impl.engine.http2.TelemetrySpi;
import org.apache.pekko.http.impl.engine.http2.client.ResponseParsing$;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer$;
import org.apache.pekko.http.impl.engine.http2.framing.Http2FrameParsing;
import org.apache.pekko.http.impl.engine.http2.hpack.HeaderCompression$;
import org.apache.pekko.http.impl.engine.http2.hpack.HeaderDecompression;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$;
import org.apache.pekko.http.impl.engine.rendering.DateHeaderRendering;
import org.apache.pekko.http.impl.engine.server.ServerTerminator;
import org.apache.pekko.http.impl.util.ExposeAttributes;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.Http2ClientSettings;
import org.apache.pekko.http.scaladsl.settings.Http2ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Full$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Off$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ErrorLoggingVerbosity$Simple$;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.StreamTcpException;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.ThrottleMode;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@InternalApi
public final class Http2Blueprint$ {
    public static Http2Blueprint$ MODULE$;
    private final BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, ByteString, NotUsed> unwrapTls;

    static {
        new Http2Blueprint$();
    }

    public BidiFlow<HttpResponse, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, HttpRequest, ServerTerminator> serverStackTls(ServerSettings settings, LoggingAdapter log, TelemetrySpi telemetry, DateHeaderRendering dateHeaderRendering) {
        Seq<FrameEvent.Setting> x$5 = this.serverStack$default$3();
        boolean x$6 = this.serverStack$default$4();
        return this.serverStack(settings, log, x$5, x$6, telemetry, dateHeaderRendering).atop(this.unwrapTls()).atop(LogByteStringTools$.MODULE$.logTLSBidiBySetting("server-plain-text", settings.logUnencryptedNetworkBytes()));
    }

    public BidiFlow<HttpResponse, ByteString, ByteString, HttpRequest, ServerTerminator> serverStack(ServerSettings settings, LoggingAdapter log, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded, TelemetrySpi telemetry, DateHeaderRendering dateHeaderRendering) {
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log);
        BidiFlow initialFlow = this.BidiFlowExt(telemetry.serverConnection().atop(this.httpLayer(settings, log, dateHeaderRendering))).atopKeepRight(this.serverDemux(settings.http2Settings(), initialDemuxerSettings, upgraded)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding(masterHttpHeaderParser, settings.parserSettings()));
        Set<String> frameTypesForThrottle = this.getFrameTypesForThrottle(settings.http2Settings());
        return (frameTypesForThrottle.nonEmpty() ? this.BidiFlowExt(initialFlow.atop(this.rapidResetMitigation(settings.http2Settings(), frameTypesForThrottle))).atopKeepLeft(this.framing(log)) : initialFlow.atop(this.framing(log))).atop(this.errorHandling(log)).atop(this.idleTimeoutIfConfigured(ServerSettings$.MODULE$.timeoutsShortcut(settings).idleTimeout()));
    }

    public Seq<FrameEvent.Setting> serverStack$default$3() {
        return Nil$.MODULE$;
    }

    public boolean serverStack$default$4() {
        return false;
    }

    public BidiFlow<HttpRequest, ByteString, ByteString, HttpResponse, NotUsed> clientStack(ClientConnectionSettings settings, LoggingAdapter log, TelemetrySpi telemetry) {
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(settings.parserSettings(), log);
        return telemetry.client().atop(this.httpLayerClient(masterHttpHeaderParser, settings, log)).atop(this.clientDemux(settings.http2Settings(), masterHttpHeaderParser)).atop(FrameLogger$.MODULE$.logFramesIfEnabled(settings.http2Settings().logFrames())).atop(this.hpackCoding(masterHttpHeaderParser, settings.parserSettings())).atop(this.framingClient(log)).atop(this.errorHandling(log)).atop(this.idleTimeoutIfConfigured(settings.idleTimeout()));
    }

    /*
     * WARNING - void declaration
     */
    public BidiFlow<HttpRequest, Http2SubStream, Http2SubStream, HttpResponse, NotUsed> httpLayerClient(HttpHeaderParser masterHttpHeaderParser, ClientConnectionSettings settings, LoggingAdapter log) {
        void statefulAttrsMap_functionConstructor;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)attrs -> arg_0 -> Http2Blueprint$.$anonfun$httpLayerClient$5(masterHttpHeaderParser.createShallowCopy(), settings, attrs, arg_0);
        if (StreamUtils$.MODULE$ == null) {
            throw null;
        }
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().statefulMap((Function0 & Serializable & scala.Serializable)() -> new RequestRendering(settings, log), (Function2 & Serializable & scala.Serializable)(renderer, request) -> new Tuple2(renderer, (Object)renderer.apply(request)), (Function1 & Serializable & scala.Serializable)x$1 -> None$.MODULE$), (Graph)Flow$.MODULE$.apply().via(new ExposeAttributes(statefulAttrsMap_functionConstructor)));
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> idleTimeoutIfConfigured(Duration timeout) {
        if (timeout instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)timeout;
            return HttpConnectionIdleTimeoutBidi$.MODULE$.apply(finiteDuration, (Option<InetSocketAddress>)None$.MODULE$);
        }
        return BidiFlow$.MODULE$.identity();
    }

    /*
     * WARNING - void declaration
     */
    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> errorHandling(LoggingAdapter log) {
        void encodeErrorAndComplete_f;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof Http2Compliance.Http2ProtocolException) {
                Http2Compliance.Http2ProtocolException http2ProtocolException = (Http2Compliance.Http2ProtocolException)x0$1;
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuilder(71).append("HTTP2 connection failed with error [").append(http2ProtocolException.getMessage()).append("]. Sending ").append(http2ProtocolException.errorCode()).append(" and closing connection.").toString());
                }
                return FrameRenderer$.MODULE$.render(new FrameEvent.GoAwayFrame(0, http2ProtocolException.errorCode(), FrameEvent$GoAwayFrame$.MODULE$.apply$default$3()));
            }
            if (x0$1 instanceof StreamTcpException) {
                throw (StreamTcpException)x0$1;
            }
            if (x0$1 instanceof HttpIdleTimeoutException) {
                throw (HttpIdleTimeoutException)x0$1;
            }
            Option option = NonFatal$.MODULE$.unapply(x0$1);
            if (!option.isEmpty()) {
                Throwable ex = (Throwable)option.get();
                log.error(new StringBuilder(85).append("HTTP2 connection failed with error [").append(ex.getMessage()).append("]. Sending INTERNAL_ERROR and closing connection.").toString());
                return FrameRenderer$.MODULE$.render(new FrameEvent.GoAwayFrame(0, Http2Protocol$ErrorCode$INTERNAL_ERROR$.MODULE$, FrameEvent$GoAwayFrame$.MODULE$.apply$default$3()));
            }
            throw new MatchError(x0$1);
        };
        if (StreamUtils$.MODULE$ == null) {
            throw null;
        }
        return BidiFlow$.MODULE$.fromFlows((Graph)((Flow)Flow$.MODULE$.apply().recoverWithRetries(1, (PartialFunction)new scala.Serializable((Function1)encodeErrorAndComplete_f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    try {
                        return (B1)Source$.MODULE$.single(this.f$2.apply(x1));
                    }
                    catch (Throwable throwable) {
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        if (!option.isEmpty()) {
                            Throwable ex = (Throwable)option.get();
                            return (B1)Source$.MODULE$.failed(ex);
                        }
                        throw throwable;
                    }
                }
                return (B1)function1.apply(null);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 != null;
            }
            {
                this.f$2 = f$2;
            }
        })), (Graph)Flow$.MODULE$.apply());
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framing(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)frame -> FrameRenderer$.MODULE$.render((FrameEvent)frame)), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(true, log)));
    }

    public BidiFlow<FrameEvent, ByteString, ByteString, FrameEvent, NotUsed> framingClient(LoggingAdapter log) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)frame -> FrameRenderer$.MODULE$.render((FrameEvent)frame)).prepend((Graph)Source$.MODULE$.single((Object)Http2Protocol$.MODULE$.ClientConnectionPreface())), (Graph)Flow$.MODULE$.apply().via((Graph)new Http2FrameParsing(false, log)));
    }

    private BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> rapidResetMitigation(Http2ServerSettings settings, Set<String> frameTypesForThrottle) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply(), (Graph)Flow$.MODULE$.apply().throttle(settings.frameTypeThrottleCost(), settings.frameTypeThrottleInterval(), settings.frameTypeThrottleBurst(), (Function1 & Serializable & scala.Serializable)event -> BoxesRunTime.boxToInteger((int)Http2Blueprint$.frameCost$1(event, frameTypesForThrottle)), (ThrottleMode)ThrottleMode.Enforcing$.MODULE$));
    }

    private Set<String> getFrameTypesForThrottle(Http2ServerSettings settings) {
        Set<String> set = settings.frameTypeThrottleFrameTypes();
        if (set.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        return (Set)set.flatMap((Function1 & Serializable & scala.Serializable)frameType -> Option$.MODULE$.option2Iterable(MODULE$.frameTypeAliasToFrameTypeName((String)frameType)), Set$.MODULE$.canBuildFrom());
    }

    public Option<String> frameTypeAliasToFrameTypeName(String frameType) {
        String string = frameType.toLowerCase();
        if ("reset".equals(string)) {
            return new Some((Object)"RstStreamFrame");
        }
        if ("headers".equals(string)) {
            return new Some((Object)"HeadersFrame");
        }
        if ("continuation".equals(string)) {
            return new Some((Object)"ContinuationFrame");
        }
        if ("go-away".equals(string)) {
            return new Some((Object)"GoAwayFrame");
        }
        if ("priority".equals(string)) {
            return new Some((Object)"PriorityFrame");
        }
        if ("ping".equals(string)) {
            return new Some((Object)"PingFrame");
        }
        if ("push-promise".equals(string)) {
            return new Some((Object)"PushPromiseFrame");
        }
        if ("window-update".equals(string)) {
            return new Some((Object)"WindowUpdateFrame");
        }
        return None$.MODULE$;
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> hpackCoding(HttpHeaderParser masterHttpHeaderParser, ParserSettings parserSettings) {
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().via((Graph)HeaderCompression$.MODULE$), (Graph)Flow$.MODULE$.apply().via((Graph)new HeaderDecompression(masterHttpHeaderParser, parserSettings)));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, ServerTerminator> serverDemux(Http2ServerSettings settings, Seq<FrameEvent.Setting> initialDemuxerSettings, boolean upgraded) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ServerDemux(settings, initialDemuxerSettings, upgraded));
    }

    public BidiFlow<Http2SubStream, FrameEvent, FrameEvent, Http2SubStream, ServerTerminator> clientDemux(Http2ClientSettings settings, HttpHeaderParser masterHttpHeaderParser) {
        return BidiFlow$.MODULE$.fromGraph((Graph)new Http2ClientDemux(settings, masterHttpHeaderParser));
    }

    /*
     * WARNING - void declaration
     */
    public BidiFlow<HttpResponse, Http2SubStream, Http2SubStream, HttpRequest, NotUsed> httpLayer(ServerSettings settings, LoggingAdapter log, DateHeaderRendering dateHeaderRendering) {
        void statefulAttrsMap_functionConstructor;
        ParserSettings parserSettings = settings.parserSettings();
        HttpHeaderParser masterHttpHeaderParser = HttpHeaderParser$.MODULE$.apply(parserSettings, log);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)attrs -> {
            HttpHeaderParser headerParser = masterHttpHeaderParser.createShallowCopy();
            return RequestParsing$.MODULE$.parseRequest(headerParser, settings, (Attributes)attrs);
        };
        if (StreamUtils$.MODULE$ == null) {
            throw null;
        }
        return BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1)new ResponseRendering(settings, log, dateHeaderRendering)), (Graph)Flow$.MODULE$.apply().via((Graph)Flow$.MODULE$.apply().via(new ExposeAttributes(statefulAttrsMap_functionConstructor))));
    }

    public Flow<HttpRequest, HttpResponse, NotUsed> handleWithStreamIdHeader(int parallelism, Function1<HttpRequest, Future<HttpResponse>> handler, ExecutionContext ec) {
        return (Flow)Flow$.MODULE$.apply().mapAsyncUnordered(parallelism, (Function1 & Serializable & scala.Serializable)req -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future response = (Future)handler.apply(req);
            Option<Object> option = req.attribute(Http2$.MODULE$.streamId(), JavaMapping$.MODULE$.attributeKey());
            if (option instanceof Some) {
                int streamIdHeader = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                return response.map((Function1 & Serializable & scala.Serializable)x$2 -> (HttpResponse)x$2.addAttribute((AttributeKey)Http2$.MODULE$.streamId(), BoxesRunTime.boxToInteger((int)streamIdHeader)), ec);
            }
            if (None$.MODULE$.equals(option)) {
                return response;
            }
            throw new MatchError(option);
        }, ec).flatten(Predef$.MODULE$.$conforms()));
    }

    public void logParsingError(ErrorInfo info, LoggingAdapter log, ParserSettings.ErrorLoggingVerbosity setting) {
        if (ParserSettings$ErrorLoggingVerbosity$Off$.MODULE$.equals(setting)) {
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Simple$.MODULE$.equals(setting)) {
            log.warning(info.summary());
            return;
        }
        if (ParserSettings$ErrorLoggingVerbosity$Full$.MODULE$.equals(setting)) {
            log.warning(info.formatPretty());
            return;
        }
        throw new MatchError((Object)setting);
    }

    public BidiFlow<ByteString, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, ByteString, NotUsed> unwrapTls() {
        return this.unwrapTls;
    }

    public <I1, O1, I2, O2, Mat> Http2Blueprint.BidiFlowExt<I1, O1, I2, O2, Mat> BidiFlowExt(BidiFlow<I1, O1, I2, O2, Mat> bidi) {
        return new Http2Blueprint.BidiFlowExt<I1, O1, I2, O2, Mat>(bidi);
    }

    public static final /* synthetic */ HttpResponse $anonfun$httpLayerClient$5(HttpHeaderParser headerParser$1, ClientConnectionSettings settings$1, Attributes attrs$1, Http2SubStream stream) {
        return (HttpResponse)ResponseParsing$.MODULE$.parseResponse(headerParser$1, settings$1.parserSettings(), attrs$1).apply((Object)stream);
    }

    private static final int frameCost$1(FrameEvent event, Set frameTypesForThrottle$1) {
        if (frameTypesForThrottle$1.contains((Object)event.frameTypeName())) {
            return 1;
        }
        return 0;
    }

    private Http2Blueprint$() {
        MODULE$ = this;
        this.unwrapTls = BidiFlow$.MODULE$.fromFlows((Graph)Flow$.MODULE$.apply().map((Function1 & Serializable & scala.Serializable)x$3 -> new TLSProtocol.SendBytes(x$3)), (Graph)Flow$.MODULE$.apply().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends TLSProtocol.SslTlsInbound, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof TLSProtocol.SessionBytes) {
                    return (B1)((TLSProtocol.SessionBytes)x1).bytes();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(TLSProtocol.SslTlsInbound x1) {
                return x1 instanceof TLSProtocol.SessionBytes;
            }
        }));
    }
}

