/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser$;
import org.apache.pekko.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$MessageEnd$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$NeedNextRequestMethod$;
import org.apache.pekko.http.impl.engine.parsing.ParsingException;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.SslSessionInfo$;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.UniversalEntity;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Promise;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\r\u001da!\u0002\u001b6\u0001m\u001a\u0005\u0002C+\u0001\u0005\u000b\u0007I\u0011C,\t\u0011}\u0003!\u0011!Q\u0001\naC\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t\"\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005E\")a\r\u0001C\u0001O\"11\u000e\u0001Q!\n1D\u0001B!\u0006\u0001A\u0003&!q\u0003\u0005\n\u0005;\u0001!\u0019!C#\u0005?A\u0001B!\n\u0001A\u00035!\u0011\u0005\u0005\b\u0005O\u0001AQ\u0001B\u0015\u0011\u001d\u0011Y\u0003\u0001C\u0003\u0005[AqAa\r\u0001\t\u000b\u0011)\u0004C\u0004\u00038\u0001!)A!\u000f\t\u000f\tm\u0002\u0001\"\u0012\u0003>!9!1\t\u0001\u0005R\t\u0015\u0003b\u0002B4\u0001\u0011\u0015#\u0011\u000e\u0005\b\u0005g\u0002A\u0011\u0002B;\u0011\u001d\u0011i\b\u0001C\u0001\u0005\u007fBqA!!\u0001\t+\u0011\u0019\tC\u0004\u0003j\u0002!IAa;\b\rE,\u0004\u0012A\u001es\r\u0019!T\u0007#\u0001<g\")aM\u0006C\u0001i\u001a)QO\u0006\"<m\"AQ\u0010\u0007BK\u0002\u0013\u0005a\u0010C\u0005\u0002\fa\u0011\t\u0012)A\u0005\u007f\"Q\u0011Q\u0002\r\u0003\u0016\u0004%\t!a\u0004\t\u0015\u0005\u0015\u0002D!E!\u0002\u0013\t\t\u0002\u0003\u0004g1\u0011\u0005\u0011q\u0005\u0005\n\u0003cA\u0012\u0011!C\u0001\u0003gA\u0011\"!\u000f\u0019#\u0003%\t!a\u000f\t\u0013\u0005E\u0003$%A\u0005\u0002\u0005M\u0003\"CA,1\u0005\u0005I\u0011IA-\u0011%\tY\u0007GA\u0001\n\u0003\ti\u0007C\u0005\u0002va\t\t\u0011\"\u0001\u0002x!I\u00111\u0011\r\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003'C\u0012\u0011!C\u0001\u0003+C\u0011\"a(\u0019\u0003\u0003%\t%!)\t\u0013\u0005\r\u0006$!A\u0005B\u0005\u0015\u0006\"CAT1\u0005\u0005I\u0011IAU\u000f)\tiKFA\u0001\u0012\u0003Y\u0014q\u0016\u0004\nkZ\t\t\u0011#\u0001<\u0003cCaA\u001a\u0016\u0005\u0002\u0005}\u0006\"CARU\u0005\u0005IQIAS\u0011%\t\tMKA\u0001\n\u0003\u000b\u0019\rC\u0005\u0002J*\n\t\u0011\"!\u0002L\"I\u0011\u0011\u001c\u0016\u0002\u0002\u0013%\u00111\\\u0004\t\u0003G4\u0002\u0012A\u001e\u0002f\u001aA\u0011q\u001d\f\t\u0002m\nI\u000f\u0003\u0004gc\u0011\u0005!1\u0003\u0005\n\u00033\f\u0014\u0011!C\u0005\u00037\u0014!\u0003\u0013;uaJ+7\u000f]8og\u0016\u0004\u0016M]:fe*\u0011agN\u0001\ba\u0006\u00148/\u001b8h\u0015\tA\u0014(\u0001\u0004f]\u001eLg.\u001a\u0006\u0003um\nA![7qY*\u0011A(P\u0001\u0005QR$\bO\u0003\u0002?\u007f\u0005)\u0001/Z6l_*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h'\r\u0001AI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0007-ce*D\u00016\u0013\tiUGA\tIiR\u0004X*Z:tC\u001e,\u0007+\u0019:tKJ\u0004\"a\u0014*\u000f\u0005-\u0003\u0016BA)6\u00031\u0001\u0016M]:fe>+H\u000f];u\u0013\t\u0019FK\u0001\bSKN\u0004xN\\:f\u001fV$\b/\u001e;\u000b\u0005E+\u0014\u0001C:fiRLgnZ:\u0004\u0001U\t\u0001\f\u0005\u0002Z;6\t!L\u0003\u0002V7*\u0011AlO\u0001\tg\u000e\fG.\u00193tY&\u0011aL\u0017\u0002\u000f!\u0006\u00148/\u001a:TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\u0007iK\u0006$WM\u001d)beN,'/F\u0001c!\tY5-\u0003\u0002ek\t\u0001\u0002\n\u001e;q\u0011\u0016\fG-\u001a:QCJ\u001cXM]\u0001\u000eQ\u0016\fG-\u001a:QCJ\u001cXM\u001d\u0011\u0002\rqJg.\u001b;?)\rA\u0017N\u001b\t\u0003\u0017\u0002AQ!V\u0003A\u0002aCQ\u0001Y\u0003A\u0002\t\f\u0011dY8oi\u0016DHOR8s\u0007V\u0014(/\u001a8u%\u0016\u001c\bo\u001c8tKB\u0019Q)\\8\n\u000594%AB(qi&|g\u000e\u0005\u0002q19\u00111*F\u0001\u0013\u0011R$\bOU3ta>t7/\u001a)beN,'\u000f\u0005\u0002L-M\u0011a\u0003\u0012\u000b\u0002e\ny!+Z:q_:\u001cXmQ8oi\u0016DHo\u0005\u0003\u0019\t^T\bCA#y\u0013\tIhIA\u0004Qe>$Wo\u0019;\u0011\u0005\u0015[\u0018B\u0001?G\u00051\u0019VM]5bY&T\u0018M\u00197f\u00035\u0011X-];fgRlU\r\u001e5pIV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aW\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0006IiR\u0004X*\u001a;i_\u0012\faB]3rk\u0016\u001cH/T3uQ>$\u0007%A\rp]\u0016DUO\u001c3sK\u0012\u001cuN\u001c;j]V,GK]5hO\u0016\u0014XCAA\t!\u0011)U.a\u0005\u0011\r\u0005U\u00111DA\u0010\u001b\t\t9BC\u0002\u0002\u001a\u0019\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\ti\"a\u0006\u0003\u000fA\u0013x.\\5tKB\u0019Q)!\t\n\u0007\u0005\rbI\u0001\u0003V]&$\u0018AG8oK\"+h\u000e\u001a:fI\u000e{g\u000e^5ok\u0016$&/[4hKJ\u0004CCBA\u0015\u0003[\ty\u0003E\u0002\u0002,ai\u0011A\u0006\u0005\u0006{v\u0001\ra \u0005\b\u0003\u001bi\u0002\u0019AA\t\u0003\u0011\u0019w\u000e]=\u0015\r\u0005%\u0012QGA\u001c\u0011\u001dih\u0004%AA\u0002}D\u0011\"!\u0004\u001f!\u0003\u0005\r!!\u0005\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\b\u0016\u0004\u007f\u0006}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-c)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u000b\u0016\u0005\u0003#\ty$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0002B!!\u0018\u0002h5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0003mC:<'BAA3\u0003\u0011Q\u0017M^1\n\t\u0005%\u0014q\f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0004cA#\u0002r%\u0019\u00111\u000f$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\u0014q\u0010\t\u0004\u000b\u0006m\u0014bAA?\r\n\u0019\u0011I\\=\t\u0013\u0005\u00055%!AA\u0002\u0005=\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\bB1\u0011\u0011RAH\u0003sj!!a#\u000b\u0007\u00055e)\u0001\u0006d_2dWm\u0019;j_:LA!!%\u0002\f\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9*!(\u0011\u0007\u0015\u000bI*C\u0002\u0002\u001c\u001a\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0002\u0016\n\t\u00111\u0001\u0002z\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002p\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\\\u00051Q-];bYN$B!a&\u0002,\"I\u0011\u0011\u0011\u0015\u0002\u0002\u0003\u0007\u0011\u0011P\u0001\u0010%\u0016\u001c\bo\u001c8tK\u000e{g\u000e^3yiB\u0019\u00111\u0006\u0016\u0014\t)\n\u0019L\u001f\t\n\u0003k\u000bYl`A\t\u0003Si!!a.\u000b\u0007\u0005ef)A\u0004sk:$\u0018.\\3\n\t\u0005u\u0016q\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAX\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tI#!2\u0002H\")Q0\fa\u0001\u007f\"9\u0011QB\u0017A\u0002\u0005E\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001b\f)\u000e\u0005\u0003F[\u0006=\u0007CB#\u0002R~\f\t\"C\u0002\u0002T\u001a\u0013a\u0001V;qY\u0016\u0014\u0004\"CAl]\u0005\u0005\t\u0019AA\u0015\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002^B!\u0011QLAp\u0013\u0011\t\t/a\u0018\u0003\r=\u0013'.Z2u\u0003]ye.\u001a%v]\u0012\u0014X\rZ\"p]RLg.^3FeJ|'\u000fE\u0002\u0002,E\u0012qc\u00148f\u0011VtGM]3e\u0007>tG/\u001b8vK\u0016\u0013(o\u001c:\u0014\u000bE\nYOa\u0001\u0011\t\u00055\u0018Q \b\u0005\u0003_\fIP\u0004\u0003\u0002r\u0006]XBAAz\u0015\r\t)PV\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dK1!a?G\u0003\u001d\u0001\u0018mY6bO\u0016LA!a@\u0003\u0002\t\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u0004\u0003w4\u0005\u0003\u0002B\u0003\u0005\u001fi!Aa\u0002\u000b\t\t%!1B\u0001\bG>tGO]8m\u0015\r\u0011iAR\u0001\u0005kRLG.\u0003\u0003\u0003\u0012\t\u001d!\u0001\u0004(p'R\f7m\u001b+sC\u000e,GCAAs\u0003)\u0019H/\u0019;vg\u000e{G-\u001a\t\u0005\u0003\u0003\u0011I\"\u0003\u0003\u0003\u001c\u0005\r!AC*uCR,8oQ8eK\u0006\u0001\u0012n\u001d*fgB|gn]3QCJ\u001cXM]\u000b\u0003\u0005Cy!Aa\t\u001a\u0003\u0005\t\u0011#[:SKN\u0004xN\\:f!\u0006\u00148/\u001a:!\u0003E\u0019'/Z1uKNC\u0017\r\u001c7po\u000e{\u0007/\u001f\u000b\u0002Q\u0006I2/\u001a;D_:$X\r\u001f;G_JtU\r\u001f;SKN\u0004xN\\:f)\u0011\tyBa\f\t\r\tE2\u00021\u0001p\u0003=\u0011Xm\u001d9p]N,7i\u001c8uKb$\u0018AB8o!VdG\u000eF\u0001O\u0003Ayg.\u00169tiJ,\u0017-\u001c$j]&\u001c\b\u000e\u0006\u0002\u0002\u0018\u0006!Q-\\5u)\u0011\tyBa\u0010\t\r\t\u0005c\u00021\u0001O\u0003\u0019yW\u000f\u001e9vi\u0006a\u0001/\u0019:tK6+7o]1hKR1!q\tB+\u0005G\u0002BA!\u0013\u0003P9\u00191Ja\u0013\n\u0007\t5S'A\tIiR\u0004X*Z:tC\u001e,\u0007+\u0019:tKJLAA!\u0015\u0003T\tY1\u000b^1uKJ+7/\u001e7u\u0015\r\u0011i%\u000e\u0005\b\u0005/z\u0001\u0019\u0001B-\u0003\u0015Ig\u000e];u!\u0011\u0011YFa\u0018\u000e\u0005\tu#b\u0001B\u0007{%!!\u0011\rB/\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0005\b\u0005Kz\u0001\u0019AA8\u0003\u0019ygMZ:fi\u0006iqN\u001c\"bIB\u0013x\u000e^8d_2$BAa\u001b\u0003rA\u0019QI!\u001c\n\u0007\t=dIA\u0004O_RD\u0017N\\4\t\u000f\t]\u0003\u00031\u0001\u0003Z\u0005Y\u0001/\u0019:tKN#\u0018\r^;t)\u0019\tyGa\u001e\u0003z!9!qK\tA\u0002\te\u0003b\u0002B>#\u0001\u0007\u0011qN\u0001\u0007GV\u00148o\u001c:\u00029!\fg\u000e\u001a7f\u0013:4wN]7bi&|g.\u00197SKN\u0004xN\\:fgV\u0011\u0011qS\u0001\fa\u0006\u00148/Z#oi&$\u0018\u0010\u0006\r\u0003H\t\u0015%Q\u0013BP\u0005C\u0013)K!.\u0003B\n\u0015'\u0011\u001aBg\u0005#DqAa\"\u0014\u0001\u0004\u0011I)A\u0004iK\u0006$WM]:\u0011\r\u00055(1\u0012BH\u0013\u0011\u0011iI!\u0001\u0003\t1K7\u000f\u001e\t\u0005\u0003\u0003\u0011\t*\u0003\u0003\u0003\u0014\u0006\r!A\u0003%uiBDU-\u00193fe\"9!qS\nA\u0002\te\u0015\u0001\u00039s_R|7m\u001c7\u0011\t\u0005\u0005!1T\u0005\u0005\u0005;\u000b\u0019A\u0001\u0007IiR\u0004\bK]8u_\u000e|G\u000eC\u0004\u0003XM\u0001\rA!\u0017\t\u000f\t\r6\u00031\u0001\u0002p\u0005I!m\u001c3z'R\f'\u000f\u001e\u0005\b\u0005O\u001b\u0002\u0019\u0001BU\u0003\r\u0019G\u000e\u001b\t\u0005\u000b6\u0014Y\u000b\u0005\u0003\u0003.\nEVB\u0001BX\u0015\u0011\u00119)a\u0001\n\t\tM&q\u0016\u0002\u0014\u0007>tG/\u001a8uI5Lg.^:MK:<G\u000f\u001b\u0005\b\u0005o\u001b\u0002\u0019\u0001B]\u0003\r\u0019G\u000f\u001b\t\u0005\u000b6\u0014Y\f\u0005\u0003\u0003.\nu\u0016\u0002\u0002B`\u0005_\u0013\u0011cQ8oi\u0016tG\u000fJ7j]V\u001cH+\u001f9f\u0011\u001d\u0011\u0019m\u0005a\u0001\u0003/\u000b\u0011\"[:DQVt7.\u001a3\t\u000f\t\u001d7\u00031\u0001\u0002\u0018\u0006\tR\r\u001f9fGR\f\u0004\u0007M2p]RLg.^3\t\u000f\t-7\u00031\u0001\u0002\u0018\u0006\t\u0002n\\:u\u0011\u0016\fG-\u001a:Qe\u0016\u001cXM\u001c;\t\u000f\t=7\u00031\u0001\u0002\u0018\u0006a2\r\\8tK\u00063G/\u001a:SKN\u0004xN\\:f\u0007>l\u0007\u000f\\3uS>t\u0007b\u0002Bj'\u0001\u0007!Q[\u0001\u000bgNd7+Z:tS>t\u0007\u0003\u0002Bl\u0005Kl!A!7\u000b\t\tm'Q\\\u0001\u0004gNd'\u0002\u0002Bp\u0005C\f1A\\3u\u0015\t\u0011\u0019/A\u0003kCZ\f\u00070\u0003\u0003\u0003h\ne'AC*T\u0019N+7o]5p]\u0006\u0001\u0002/\u0019:tKR{7\t\\8tK\n{G-\u001f\u000b\t\u0005\u000f\u0012iOa<\u0003r\"9!q\u000b\u000bA\u0002\te\u0003b\u0002BR)\u0001\u0007\u0011q\u000e\u0005\b\u0005g$\u0002\u0019\u0001B{\u00039!x\u000e^1m\u0005f$Xm\u001d*fC\u0012\u00042!\u0012B|\u0013\r\u0011IP\u0012\u0002\u0005\u0019>tw\rK\u0002\u0001\u0005{\u0004BAa@\u0004\u00045\u00111\u0011\u0001\u0006\u0004\u0003\u0017j\u0014\u0002BB\u0003\u0007\u0003\u00111\"\u00138uKJt\u0017\r\\!qS\u0002")
@InternalApi
public class HttpResponseParser
implements HttpMessageParser<ParserOutput.ResponseOutput> {
    private final ParserSettings settings;
    private final HttpHeaderParser headerParser;
    private Option<ResponseContext> contextForCurrentResponse;
    private StatusCode statusCode;
    private Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
    private Function1<ByteString, HttpMessageParser.StateResult> org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
    private HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
    private Function0<Option<ParserOutput.ErrorOutput>> completionHandling;
    private boolean terminated;
    private SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
    private Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;

    @Override
    public final ListBuffer<HttpHeader> initialHeaderBuffer() {
        return HttpMessageParser.initialHeaderBuffer$(this);
    }

    @Override
    public final ParserOutput parseSessionBytes(TLSProtocol.SessionBytes input) {
        return HttpMessageParser.parseSessionBytes$(this, input);
    }

    @Override
    public final ParserOutput parseBytes(ByteString input) {
        return HttpMessageParser.parseBytes$(this, input);
    }

    @Override
    public final ParserOutput doPull() {
        return HttpMessageParser.doPull$(this);
    }

    @Override
    public final boolean shouldComplete() {
        return HttpMessageParser.shouldComplete$(this);
    }

    @Override
    public final HttpMessageParser.StateResult startNewMessage(ByteString input, int offset) {
        return HttpMessageParser.startNewMessage$(this, input, offset);
    }

    @Override
    public final int parseProtocol(ByteString input, int cursor) {
        return HttpMessageParser.parseProtocol$(this, input, cursor);
    }

    @Override
    public final HttpMessageParser.StateResult parseHeaderLines(ByteString input, int lineStart, ListBuffer<HttpHeader> headers2, int headerCount, Option<Connection> ch, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean e100c, boolean hh) {
        return HttpMessageParser.parseHeaderLines$(this, input, lineStart, headers2, headerCount, ch, clh, cth, isChunked, e100c, hh);
    }

    @Override
    public final HttpMessageParser.StateResult parseFixedLengthBody(long remainingBodyBytes, boolean isLastMessage, ByteString input, int bodyStart) {
        return HttpMessageParser.parseFixedLengthBody$(this, remainingBodyBytes, isLastMessage, input, bodyStart);
    }

    @Override
    public final HttpMessageParser.StateResult parseChunk(ByteString input, int offset, boolean isLastMessage, long totalBytesRead) {
        return HttpMessageParser.parseChunk$(this, input, offset, isLastMessage, totalBytesRead);
    }

    @Override
    public final HttpMessageParser.StateResult continue(ByteString input, int offset, Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
        return HttpMessageParser.continue$(this, input, offset, next);
    }

    @Override
    public final HttpMessageParser.StateResult continue(Function2<ByteString, Object, HttpMessageParser.StateResult> next) {
        return HttpMessageParser.continue$(this, next);
    }

    @Override
    public final HttpMessageParser.StateResult failMessageStart(String summary) {
        return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary);
    }

    @Override
    public final HttpMessageParser.StateResult failMessageStart(String summary, String detail) {
        return HttpMessageParser.failMessageStart$((HttpMessageParser)this, summary, detail);
    }

    @Override
    public final HttpMessageParser.StateResult failMessageStart(StatusCode status) {
        return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status);
    }

    @Override
    public final HttpMessageParser.StateResult failMessageStart(StatusCode status, String summary, String detail) {
        return HttpMessageParser.failMessageStart$(this, status, summary, detail);
    }

    @Override
    public final String failMessageStart$default$3() {
        return HttpMessageParser.failMessageStart$default$3$(this);
    }

    @Override
    public final HttpMessageParser.StateResult failMessageStart(StatusCode status, ErrorInfo info) {
        return HttpMessageParser.failMessageStart$((HttpMessageParser)this, status, info);
    }

    @Override
    public final HttpMessageParser.StateResult failEntityStream(String summary) {
        return HttpMessageParser.failEntityStream$((HttpMessageParser)this, summary);
    }

    @Override
    public final HttpMessageParser.StateResult failEntityStream(String summary, String detail) {
        return HttpMessageParser.failEntityStream$(this, summary, detail);
    }

    @Override
    public final HttpMessageParser.StateResult failEntityStream(ErrorInfo info) {
        return HttpMessageParser.failEntityStream$((HttpMessageParser)this, info);
    }

    @Override
    public final HttpMessageParser.StateResult terminate() {
        return HttpMessageParser.terminate$(this);
    }

    @Override
    public final ContentType contentType(Option<Content$minusType> cth) {
        return HttpMessageParser.contentType$(this, cth);
    }

    @Override
    public final ParserOutput.StrictEntityCreator<ParserOutput.ResponseOutput, UniversalEntity> emptyEntity(Option<Content$minusType> cth) {
        return HttpMessageParser.emptyEntity$(this, cth);
    }

    @Override
    public final ParserOutput.StrictEntityCreator<ParserOutput.ResponseOutput, UniversalEntity> strictEntity(Option<Content$minusType> cth, ByteString input, int bodyStart, int contentLength) {
        return HttpMessageParser.strictEntity$(this, cth, input, bodyStart, contentLength);
    }

    @Override
    public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, UniversalEntity> defaultEntity(Option<Content$minusType> cth, long contentLength) {
        return HttpMessageParser.defaultEntity$(this, cth, contentLength);
    }

    @Override
    public final <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, RequestEntity> chunkedEntity(Option<Content$minusType> cth) {
        return HttpMessageParser.chunkedEntity$(this, cth);
    }

    @Override
    public final void setCompletionHandling(Function0<Option<ParserOutput.ErrorOutput>> completionHandling) {
        HttpMessageParser.setCompletionHandling$(this, completionHandling);
    }

    @Override
    public final ListBuffer<HttpHeader> parseHeaderLines$default$3() {
        return HttpMessageParser.parseHeaderLines$default$3$(this);
    }

    @Override
    public final int parseHeaderLines$default$4() {
        return HttpMessageParser.parseHeaderLines$default$4$(this);
    }

    @Override
    public final Option<Connection> parseHeaderLines$default$5() {
        return HttpMessageParser.parseHeaderLines$default$5$(this);
    }

    @Override
    public final Option<Content$minusLength> parseHeaderLines$default$6() {
        return HttpMessageParser.parseHeaderLines$default$6$(this);
    }

    @Override
    public final Option<Content$minusType> parseHeaderLines$default$7() {
        return HttpMessageParser.parseHeaderLines$default$7$(this);
    }

    @Override
    public final boolean parseHeaderLines$default$8() {
        return HttpMessageParser.parseHeaderLines$default$8$(this);
    }

    @Override
    public final boolean parseHeaderLines$default$9() {
        return HttpMessageParser.parseHeaderLines$default$9$(this);
    }

    @Override
    public final boolean parseHeaderLines$default$10() {
        return HttpMessageParser.parseHeaderLines$default$10$(this);
    }

    @Override
    public Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(Object x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result = x$1;
    }

    @Override
    public Function1<ByteString, HttpMessageParser.StateResult> org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq(Function1<ByteString, HttpMessageParser.StateResult> x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state = x$1;
    }

    @Override
    public HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocol x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol = x$1;
    }

    @Override
    public Function0<Option<ParserOutput.ErrorOutput>> completionHandling() {
        return this.completionHandling;
    }

    @Override
    public void completionHandling_$eq(Function0<Option<ParserOutput.ErrorOutput>> x$1) {
        this.completionHandling = x$1;
    }

    @Override
    public boolean terminated() {
        return this.terminated;
    }

    @Override
    public void terminated_$eq(boolean x$1) {
        this.terminated = x$1;
    }

    @Override
    public SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(SSLSession x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession = x$1;
    }

    @Override
    public Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() {
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader;
    }

    @Override
    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo x$1) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader = x$1;
    }

    @Override
    public ParserSettings settings() {
        return this.settings;
    }

    @Override
    public HttpHeaderParser headerParser() {
        return this.headerParser;
    }

    @Override
    public final boolean isResponseParser() {
        return true;
    }

    public final HttpResponseParser createShallowCopy() {
        return new HttpResponseParser(this.settings(), this.headerParser().createShallowCopy());
    }

    public final void setContextForNextResponse(ResponseContext responseContext) {
        if (this.contextForCurrentResponse.isEmpty()) {
            this.contextForCurrentResponse = new Some((Object)responseContext);
            return;
        }
    }

    public final ParserOutput.ResponseOutput onPull() {
        return (ParserOutput.ResponseOutput)this.doPull();
    }

    public final boolean onUpstreamFinish() {
        return this.shouldComplete();
    }

    @Override
    public final void emit(ParserOutput.ResponseOutput output) {
        ParserOutput.ResponseOutput responseOutput = output;
        ParserOutput$MessageEnd$ parserOutput$MessageEnd$ = ParserOutput$MessageEnd$.MODULE$;
        if (!(responseOutput != null ? !responseOutput.equals(parserOutput$MessageEnd$) : parserOutput$MessageEnd$ != null)) {
            this.contextForCurrentResponse = None$.MODULE$;
        }
        HttpMessageParser.emit$(this, output);
    }

    @Override
    public HttpMessageParser.StateResult parseMessage(ByteString input2, int offset2) {
        if (this.contextForCurrentResponse.isDefined()) {
            int cursor = this.parseProtocol(input2, offset2);
            if (package$.MODULE$.byteChar(input2, cursor) == ' ') {
                cursor = this.parseStatus(input2, cursor + 1);
                return this.parseHeaderLines(input2, cursor, this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5(), this.parseHeaderLines$default$6(), this.parseHeaderLines$default$7(), this.parseHeaderLines$default$8(), this.parseHeaderLines$default$9(), this.parseHeaderLines$default$10());
            }
            throw this.onBadProtocol(input2.drop(cursor));
        }
        this.emit(ParserOutput$NeedNextRequestMethod$.MODULE$);
        Function2 & Serializable & scala.Serializable continue_next = (Function2 & Serializable & scala.Serializable)(input, offset) -> this.startNewMessage(input, BoxesRunTime.unboxToInt((Object)offset));
        return HttpMessageParser.continue$(this, input2, offset2, continue_next);
    }

    @Override
    public final Nothing$ onBadProtocol(ByteString input) {
        throw new ParsingException("The server-side protocol or HTTP version is not supported", new StringBuilder(21).append("start of response: [").append(LogByteStringTools$.MODULE$.printByteString(input.take(16), 16, false, "")).append("]").toString());
    }

    private int parseStatus(ByteString input, int cursor) {
        if (package$.MODULE$.byteChar(input, cursor + 3) == ' ') {
            int startIdx = cursor + 4;
            int newLineIdx = this.scanNewLineIdx$1(startIdx, startIdx, input);
            this.parseStatusCode$1(startIdx, newLineIdx, input, cursor);
            return HttpResponseParser.skipNewLine$1(newLineIdx, input);
        }
        if (HttpResponseParser.isNewLine$1(cursor + 3, input)) {
            this.parseStatusCode$1(HttpResponseParser.parseStatusCode$default$1$1(), HttpResponseParser.parseStatusCode$default$2$1(), input, cursor);
            return HttpResponseParser.skipNewLine$1(cursor + 3, input);
        }
        throw HttpResponseParser.badStatusCode$1();
    }

    public boolean handleInformationalResponses() {
        return true;
    }

    @Override
    public final HttpMessageParser.StateResult parseEntity(List<HttpHeader> headers2, HttpProtocol protocol, ByteString input, int bodyStart, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean expect100continue, boolean hostHeaderPresent, boolean closeAfterResponseCompletion, SSLSession sslSession) {
        if (this.statusCode.allowsEntity()) {
            HttpMethod httpMethod = ((ResponseContext)this.contextForCurrentResponse.get()).requestMethod();
            HttpMethod httpMethod2 = HttpMethods$.MODULE$.HEAD();
            if (!(httpMethod2 != null ? !((Object)httpMethod2).equals(httpMethod) : httpMethod != null)) {
                long contentLength;
                Content$minusLength content$minusLength;
                if (clh instanceof Some && (content$minusLength = (Content$minusLength)((Some)clh).value()) != null && (contentLength = content$minusLength.length()) > 0L) {
                    this.emitResponseStart$1(new ParserOutput.StrictEntityCreator(new HttpEntity.Default(this.contentType(cth), contentLength, (Source<ByteString, Object>)Source$.MODULE$.empty())), HttpResponseParser.emitResponseStart$default$2$1(headers2), sslSession, closeAfterResponseCompletion, protocol);
                    this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                    this.emit(ParserOutput$MessageEnd$.MODULE$);
                    return this.startNewMessage(input, bodyStart);
                }
                return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers2);
            }
            HttpMethod httpMethod3 = HttpMethods$.MODULE$.CONNECT();
            if (!(httpMethod3 != null ? !((Object)httpMethod3).equals(httpMethod) : httpMethod != null)) {
                return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers2);
            }
            if (!isChunked) {
                Content$minusLength content$minusLength;
                if (clh instanceof Some && (content$minusLength = (Content$minusLength)((Some)clh).value()) != null) {
                    long contentLength = content$minusLength.length();
                    if (contentLength == 0L) {
                        return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers2);
                    }
                    if (contentLength <= (long)(input.size() - bodyStart)) {
                        int cl = (int)contentLength;
                        this.emitResponseStart$1(this.strictEntity(cth, input, bodyStart, cl), HttpResponseParser.emitResponseStart$default$2$1(headers2), sslSession, closeAfterResponseCompletion, protocol);
                        this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                        this.emit(ParserOutput$MessageEnd$.MODULE$);
                        return this.startNewMessage(input, bodyStart + cl);
                    }
                    this.emitResponseStart$1(this.defaultEntity(cth, contentLength), HttpResponseParser.emitResponseStart$default$2$1(headers2), sslSession, closeAfterResponseCompletion, protocol);
                    return this.parseFixedLengthBody(contentLength, closeAfterResponseCompletion, input, bodyStart);
                }
                if (None$.MODULE$.equals(clh)) {
                    this.emitResponseStart$1(new ParserOutput.StreamedEntityCreator((Function1 & Serializable & scala.Serializable)entityParts -> {
                        Source data = (Source)entityParts.collect((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends ParserOutput.ResponseOutput, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                if (x1 instanceof ParserOutput.EntityPart) {
                                    return (B1)((ParserOutput.EntityPart)x1).data();
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(ParserOutput.ResponseOutput x1) {
                                return x1 instanceof ParserOutput.EntityPart;
                            }
                        });
                        return new HttpEntity.CloseDelimited(this.contentType(cth), (Source<ByteString, Object>)data);
                    }), HttpResponseParser.emitResponseStart$default$2$1(headers2), sslSession, closeAfterResponseCompletion, protocol);
                    this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                    return this.parseToCloseBody(input, bodyStart, 0L);
                }
                throw new MatchError(clh);
            }
            if (clh.isEmpty()) {
                this.emitResponseStart$1(this.chunkedEntity(cth), headers2, sslSession, closeAfterResponseCompletion, protocol);
                return this.parseChunk(input, bodyStart, closeAfterResponseCompletion, 0L);
            }
            return this.failMessageStart("A chunked response must not contain a Content-Length header");
        }
        return this.finishEmptyResponse$1(input, bodyStart, cth, sslSession, closeAfterResponseCompletion, protocol, headers2);
    }

    private HttpMessageParser.StateResult parseToCloseBody(ByteString input, int bodyStart, long totalBytesRead) {
        long newTotalBytes = totalBytesRead + (long)scala.math.package$.MODULE$.max(0, input.length() - bodyStart);
        if (input.length() > bodyStart) {
            this.emit(new ParserOutput.EntityPart((ByteString)input.drop(bodyStart).compact()));
        }
        Function2 & Serializable & scala.Serializable continue_next = (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> this.parseToCloseBody(x$2, BoxesRunTime.unboxToInt((Object)x$3), newTotalBytes);
        return HttpMessageParser.continue$(this, continue_next);
    }

    private static final Nothing$ badStatusCode$1() {
        throw new ParsingException("Illegal response status code");
    }

    private static final Nothing$ badStatusCodeSpecific$1(int code) {
        throw new ParsingException(new StringBuilder(30).append("Illegal response status code: ").append(code).toString());
    }

    private static final int intValue$1(int offset, ByteString input$1, int cursor$1) {
        char c = package$.MODULE$.byteChar(input$1, cursor$1 + offset);
        if (CharacterClasses$.MODULE$.DIGIT().apply(c)) {
            return c - 48;
        }
        throw HttpResponseParser.badStatusCode$1();
    }

    private final void parseStatusCode$1(int reasonStartIdx, int reasonEndIdx, ByteString input$1, int cursor$1) {
        StatusCode statusCode;
        int code = HttpResponseParser.intValue$1(0, input$1, cursor$1) * 100 + HttpResponseParser.intValue$1(1, input$1, cursor$1) * 10 + HttpResponseParser.intValue$1(2, input$1, cursor$1);
        switch (code) {
            case 200: {
                statusCode = StatusCodes$.MODULE$.OK();
                break;
            }
            default: {
                Option option = StatusCodes$.MODULE$.getForKey(BoxesRunTime.boxToInteger((int)code));
                if (option instanceof Some) {
                    statusCode = (StatusCode)((Some)option).value();
                    break;
                }
                if (None$.MODULE$.equals(option)) {
                    statusCode = (StatusCode)((Option)this.settings().customStatusCodes().apply((Object)BoxesRunTime.boxToInteger((int)code))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        try {
                            String reason = package$.MODULE$.asciiString(input$1, reasonStartIdx, reasonEndIdx);
                            return StatusCodes$.MODULE$.custom(code, reason, StatusCodes$.MODULE$.custom$default$3());
                        }
                        catch (Throwable throwable) {
                            if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                                throw HttpResponseParser.badStatusCodeSpecific$1(code);
                            }
                            throw throwable;
                        }
                    });
                    break;
                }
                throw new MatchError((Object)option);
            }
        }
        this.statusCode = statusCode;
    }

    private static final int parseStatusCode$default$1$1() {
        return -1;
    }

    private static final int parseStatusCode$default$2$1() {
        return -1;
    }

    private static final boolean isLF$1(int idx, ByteString input$1) {
        return package$.MODULE$.byteChar(input$1, idx) == '\n';
    }

    private static final boolean isCRLF$1(int idx, ByteString input$1) {
        return package$.MODULE$.byteChar(input$1, idx) == '\r' && HttpResponseParser.isLF$1(idx + 1, input$1);
    }

    private static final boolean isNewLine$1(int idx, ByteString input$1) {
        return HttpResponseParser.isLF$1(idx, input$1) || HttpResponseParser.isCRLF$1(idx, input$1);
    }

    private static final int skipNewLine$1(int idx, ByteString input$1) {
        if (HttpResponseParser.isCRLF$1(idx, input$1)) {
            return idx + 2;
        }
        if (HttpResponseParser.isLF$1(idx, input$1)) {
            return idx + 1;
        }
        return idx;
    }

    private final int scanNewLineIdx$1(int idx, int startIdx$1, ByteString input$1) {
        while (idx - startIdx$1 <= this.settings().maxResponseReasonLength()) {
            if (HttpResponseParser.isNewLine$1(idx, input$1)) {
                return idx;
            }
            ++idx;
        }
        throw new ParsingException(new StringBuilder(66).append("Response reason phrase exceeds the configured limit of ").append(this.settings().maxResponseReasonLength()).append(" characters").toString());
    }

    /*
     * Unable to fully structure code
     */
    private final void emitResponseStart$1(ParserOutput.EntityCreator createEntity, List headers, SSLSession sslSession$1, boolean closeAfterResponseCompletion$1, HttpProtocol protocol$1) {
        block5: {
            block4: {
                attributes = this.settings().includeSslSessionAttribute() != false ? (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(AttributeKeys$.MODULE$.sslSession()), (Object)SslSessionInfo$.MODULE$.apply(sslSession$1))})) : Predef$.MODULE$.Map().empty();
                var8_7 = false;
                var9_8 = null;
                var10_9 = ((ResponseContext)this.contextForCurrentResponse.get()).oneHundredContinueTrigger();
                if (!None$.MODULE$.equals(var10_9)) break block4;
                v0 = closeAfterResponseCompletion$1;
                break block5;
            }
            if (!(var10_9 instanceof Some)) ** GOTO lbl-1000
            var8_7 = true;
            var9_8 = (Some)var10_9;
            trigger = (Promise)var9_8.value();
            if (this.statusCode.isSuccess()) {
                trigger.trySuccess((Object)BoxedUnit.UNIT);
                v0 = closeAfterResponseCompletion$1;
            } else if (var8_7) {
                ((Promise)var9_8.value()).tryFailure((Throwable)HttpResponseParser$OneHundredContinueError$.MODULE$);
                v0 = true;
            } else {
                throw new MatchError(var10_9);
            }
        }
        close = v0;
        this.emit(new ParserOutput.ResponseStart(this.statusCode, protocol$1, attributes, (List<HttpHeader>)headers, createEntity, close));
    }

    private static final List emitResponseStart$default$2$1(List headers$1) {
        return headers$1;
    }

    private final HttpMessageParser.StateResult finishEmptyResponse$1(ByteString input$2, int bodyStart$1, Option cth$1, SSLSession sslSession$1, boolean closeAfterResponseCompletion$1, HttpProtocol protocol$1, List headers$1) {
        if (this.statusCode instanceof StatusCodes.Informational && this.handleInformationalResponses()) {
            StatusCode statusCode = this.statusCode;
            StatusCodes.Informational informational = StatusCodes$.MODULE$.Continue();
            if (!(statusCode != null ? !statusCode.equals(informational) : informational != null)) {
                ((ResponseContext)this.contextForCurrentResponse.get()).oneHundredContinueTrigger().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.trySuccess((Object)BoxedUnit.UNIT)));
            }
            return this.startNewMessage(input$2, bodyStart$1);
        }
        this.emitResponseStart$1(this.emptyEntity((Option<Content$minusType>)cth$1), HttpResponseParser.emitResponseStart$default$2$1(headers$1), sslSession$1, closeAfterResponseCompletion$1, protocol$1);
        this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
        this.emit(ParserOutput$MessageEnd$.MODULE$);
        return this.startNewMessage(input$2, bodyStart$1);
    }

    public HttpResponseParser(ParserSettings settings, HttpHeaderParser headerParser) {
        this.settings = settings;
        this.headerParser = headerParser;
        HttpMessageParser.$init$(this);
        this.contextForCurrentResponse = None$.MODULE$;
        this.statusCode = StatusCodes$.MODULE$.OK();
    }

    public static final class ResponseContext
    implements Product,
    scala.Serializable {
        private final HttpMethod requestMethod;
        private final Option<Promise<BoxedUnit>> oneHundredContinueTrigger;

        public HttpMethod requestMethod() {
            return this.requestMethod;
        }

        public Option<Promise<BoxedUnit>> oneHundredContinueTrigger() {
            return this.oneHundredContinueTrigger;
        }

        public ResponseContext copy(HttpMethod requestMethod, Option<Promise<BoxedUnit>> oneHundredContinueTrigger) {
            return new ResponseContext(requestMethod, oneHundredContinueTrigger);
        }

        public HttpMethod copy$default$1() {
            return this.requestMethod();
        }

        public Option<Promise<BoxedUnit>> copy$default$2() {
            return this.oneHundredContinueTrigger();
        }

        public String productPrefix() {
            return "ResponseContext";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.requestMethod();
                }
                case 1: {
                    return this.oneHundredContinueTrigger();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResponseContext;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ResponseContext)) break block3;
                    ResponseContext responseContext = (ResponseContext)x$1;
                    HttpMethod httpMethod = this.requestMethod();
                    HttpMethod httpMethod2 = responseContext.requestMethod();
                    if (httpMethod != null ? !((Object)httpMethod).equals(httpMethod2) : httpMethod2 != null) break block3;
                    Option<Promise<BoxedUnit>> option = this.oneHundredContinueTrigger();
                    Option<Promise<BoxedUnit>> option2 = responseContext.oneHundredContinueTrigger();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                }
                return true;
            }
            return false;
        }

        public ResponseContext(HttpMethod requestMethod, Option<Promise<BoxedUnit>> oneHundredContinueTrigger) {
            this.requestMethod = requestMethod;
            this.oneHundredContinueTrigger = oneHundredContinueTrigger;
            Product.$init$((Product)this);
        }
    }
}

