/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameError;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEventOrError;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.http.impl.engine.ws.ProtocolException;
import org.apache.pekko.http.impl.util.LogByteStringTools$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class FrameLogger$ {
    public static FrameLogger$ MODULE$;

    static {
        new FrameLogger$();
    }

    public final int maxBytes() {
        return 16;
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> logFramesIfEnabled(boolean shouldLog) {
        if (shouldLog) {
            return this.bidi();
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<FrameEventOrError, FrameEventOrError, FrameEvent, FrameEvent, NotUsed> bidi() {
        Flow qual$1 = Flow$.MODULE$.apply();
        String x$1 = new StringBuilder(13).append("\u001b[31m").append("DOWN").append("\u001b[0m").toString();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)frameEvent -> MODULE$.logEvent((FrameEventOrError)frameEvent);
        LoggingAdapter x$3 = qual$1.log$default$3(x$1, (Function1)x$2);
        Flow qual$2 = Flow$.MODULE$.apply();
        String x$4 = new StringBuilder(13).append("\u001b[32m").append(" UP ").append("\u001b[0m").toString();
        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)frameEvent -> MODULE$.logEvent((FrameEventOrError)frameEvent);
        LoggingAdapter x$6 = qual$2.log$default$3(x$4, (Function1)x$5);
        return BidiFlow$.MODULE$.fromFlows((Graph)qual$1.log(x$1, (Function1)x$2, x$3), (Graph)qual$2.log(x$4, (Function1)x$5, x$6)).addAttributes(Attributes$.MODULE$.apply((Attributes.Attribute)new Attributes.LogLevels(Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel())));
    }

    public String logEvent(FrameEventOrError frameEvent) {
        if (frameEvent instanceof FrameStart) {
            FrameStart frameStart = (FrameStart)frameEvent;
            FrameHeader header = frameStart.header();
            ByteString data = frameStart.data();
            return FrameLogger$.displayLogEntry$1(header.opcode().short(), header.length(), FrameLogger$.hex$1(data), frameStart.lastPart(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(header.fin(), "FIN"), FrameLogger$.flag$1(header.rsv1(), "RSV1"), FrameLogger$.flag$1(header.rsv2(), "RSV2"), FrameLogger$.flag$1(header.rsv3(), "RSV3")}));
        }
        if (frameEvent instanceof FrameData) {
            FrameData frameData = (FrameData)frameEvent;
            ByteString data = frameData.data();
            boolean lastPart = frameData.lastPart();
            return FrameLogger$.displayLogEntry$1("DATA", 0L, FrameLogger$.hex$1(data), lastPart, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[0]));
        }
        if (frameEvent instanceof FrameError) {
            ProtocolException ex = ((FrameError)frameEvent).p();
            String arg$macro$1 = "\u001b[31m";
            String arg$macro$2 = ex.getMessage();
            String arg$macro$3 = "\u001b[0m";
            return new StringOps("%sError: %s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}));
        }
        throw new MatchError((Object)frameEvent);
    }

    private static final String displayLogEntry$1(String frameType, long length, String data, boolean lastPart, Seq flags) {
        String string;
        String f;
        String string2 = f = flags.nonEmpty() ? new StringBuilder(6).append(" ").append("\u001b[31m").append(((TraversableOnce)flags.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).mkString(" ")).toString() : "";
        if (length > 0L) {
            String arg$macro$1 = "\u001b[33m";
            string = new StringOps(" %s%d bytes").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToLong((long)length)}));
        } else {
            string = "";
        }
        String l = string;
        String arg$macro$3 = "\u001b[32m";
        String arg$macro$7 = "\u001b[0m";
        String arg$macro$9 = !lastPart ? " ..." : "";
        return new StringOps("%s%s%s%s%s %s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3, frameType, f, l, arg$macro$7, data, arg$macro$9}));
    }

    private static final Option flag$1(boolean value, String name) {
        if (value) {
            return new Some((Object)name);
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$logEvent$2(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    private static final String hex$1(ByteString bytes) {
        int num = package$.MODULE$.min(16, bytes.size());
        String ellipsis = num < bytes.size() ? new StringBuilder(18).append(" [... ").append(bytes.size() - num).append(" more bytes]").toString() : "";
        ByteString first = bytes.take(num);
        String h = ((TraversableOnce)first.map((Function1 & Serializable & scala.Serializable)x$1 -> FrameLogger$.$anonfun$logEvent$2(BoxesRunTime.unboxToByte((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
        String ascii = ((TraversableOnce)first.map((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToCharacter((char)LogByteStringTools$.MODULE$.asASCII(BoxesRunTime.unboxToByte((Object)b))), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
        return new StringBuilder(21).append("\u001b[37m").append(h).append("\u001b[0m").append(" | ").append("\u001b[37m").append(ascii).append("\u001b[0m").append(ellipsis).toString();
    }

    private FrameLogger$() {
        MODULE$ = this;
    }
}

