/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.check;

import cn.sliew.milky.common.util.StringUtils;
import java.util.Collection;
import java.util.function.Supplier;

public enum Ensures {


    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage.get().toString());
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage.get().toString());
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Supplier<Object> errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage.get().toString());
        }
        return reference;
    }

    public static <T> T[] notEmpty(T[] array) {
        Ensures.condition(array != null && array.length > 0);
        return array;
    }

    public static <T> T[] notEmpty(T[] array, Supplier<Object> errorMessage) {
        Ensures.condition(array != null && array.length > 0, errorMessage);
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(T collection) {
        Ensures.condition(collection != null && !collection.isEmpty());
        return collection;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, Supplier<Object> errorMessage) {
        Ensures.condition(collection != null && !collection.isEmpty(), errorMessage);
        return collection;
    }

    public static String notBlank(String str) {
        Ensures.condition(StringUtils.isNotBlank(str));
        return str;
    }

    public static String notBlank(String str, Supplier<Object> errorMessage) {
        Ensures.condition(StringUtils.isNotBlank(str), errorMessage);
        return str;
    }

    public static void condition(boolean predicate) {
        if (!predicate) {
            throw new IllegalStateException();
        }
    }

    public static void condition(boolean predicate, Supplier<Object> errorMessage) {
        if (!predicate) {
            throw new IllegalStateException(errorMessage.get().toString());
        }
    }
}

