/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionsHolder;
import org.redisson.misc.AsyncSemaphore;

public class TrackedConnectionsHolder
extends ConnectionsHolder<RedisConnection> {
    private final ConnectionsHolder<RedisConnection> holder;
    private final AtomicReference<CompletableFuture<RedisConnection>> connectionFuture = new AtomicReference();
    private volatile ClientConnectionsEntry entry;
    private final AtomicInteger usage = new AtomicInteger();

    public TrackedConnectionsHolder(ConnectionsHolder<RedisConnection> holder) {
        super(null, 0, null, null, false);
        this.holder = holder;
    }

    @Override
    public <R extends RedisConnection> boolean remove(R connection) {
        return this.holder.remove(connection);
    }

    @Override
    public Queue<RedisConnection> getFreeConnections() {
        return this.holder.getFreeConnections();
    }

    @Override
    public AsyncSemaphore getFreeConnectionsCounter() {
        return this.holder.getFreeConnectionsCounter();
    }

    @Override
    public Queue<RedisConnection> getAllConnections() {
        return this.holder.getAllConnections();
    }

    @Override
    public CompletableFuture<Void> initConnections(int minimumIdleSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<RedisConnection> acquireConnection(RedisCommand<?> command) {
        CompletableFuture<RedisConnection> newFuture = new CompletableFuture<RedisConnection>();
        if (!this.connectionFuture.compareAndSet(null, newFuture)) {
            return this.connectionFuture.get();
        }
        CompletableFuture<RedisConnection> f = this.holder.acquireConnection(command);
        newFuture.whenComplete((r, e) -> {
            if (e != null) {
                f.completeExceptionally((Throwable)e);
                this.connectionFuture.set(null);
            }
        });
        f.whenComplete((r, e) -> {
            if (e != null) {
                newFuture.completeExceptionally((Throwable)e);
                this.connectionFuture.set(null);
                return;
            }
            newFuture.complete((RedisConnection)r);
        });
        return newFuture;
    }

    @Override
    public void releaseConnection(ClientConnectionsEntry entry, RedisConnection connection) {
        this.entry = entry;
    }

    public void reset() {
        if (this.connectionFuture.get() != null && this.connectionFuture.get().getNow(null) != null) {
            RedisConnection c = this.connectionFuture.get().getNow(null);
            RFuture f = c.async(RedisCommands.CLIENT_TRACKING, "OFF");
            f.whenComplete((res, ex) -> this.holder.releaseConnection(this.entry, this.connectionFuture.get().getNow(null)));
        }
    }

    public void incUsage() {
        this.usage.incrementAndGet();
    }

    public int decUsage() {
        return this.usage.decrementAndGet();
    }
}

