/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Locale;

public final class TargetName {
    public static final boolean IS_EXTERNAL;
    public static final String LMDB_EMBEDDED_LIB_PROP = "lmdbjava.embedded.lib";
    public static final String LMDB_NATIVE_LIB_PROP = "lmdbjava.native.lib";
    public static final String RESOLVED_FILENAME;
    private static final String ARCH;
    private static final String EMBED;
    private static final String EXTERNAL;
    private static final String OS;

    private TargetName() {
    }

    public static String resolveExtension(String os) {
        return TargetName.check(os, "Windows") ? "dll" : "so";
    }

    static boolean isExternal(String external) {
        return external != null && !external.isEmpty();
    }

    static String resolveFilename(String external, String embed, String arch, String os) {
        if (external != null && !external.isEmpty()) {
            return external;
        }
        if (embed != null && !embed.isEmpty()) {
            return embed;
        }
        String pkg = TargetName.class.getPackage().getName().replace('.', '/');
        return pkg + "/" + TargetName.resolveArch(arch) + "-" + TargetName.resolveOs(os) + "-" + TargetName.resolveToolchain(os) + "." + TargetName.resolveExtension(os);
    }

    private static boolean check(String string, String ... candidates) {
        if (string == null) {
            return false;
        }
        String strLower = string.toLowerCase(Locale.ENGLISH);
        for (String c : candidates) {
            if (!strLower.startsWith(c.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private static String err(String reason) {
        return reason + " (please set system property " + LMDB_NATIVE_LIB_PROP + " to the path of an external LMDB native library or property " + LMDB_EMBEDDED_LIB_PROP + " to the name of an LmdbJava embedded library; os.arch='" + ARCH + "' os.name='" + OS + "')";
    }

    private static String resolveArch(String arch) {
        if (TargetName.check(arch, "aarch64")) {
            return "aarch64";
        }
        if (TargetName.check(arch, "x86_64", "amd64")) {
            return "x86_64";
        }
        throw new UnsupportedOperationException(TargetName.err("Unsupported os.arch"));
    }

    private static String resolveOs(String os) {
        if (TargetName.check(os, "Linux")) {
            return "linux";
        }
        if (TargetName.check(os, "Mac OS")) {
            return "macos";
        }
        if (TargetName.check(os, "Windows")) {
            return "windows";
        }
        throw new UnsupportedOperationException(TargetName.err("Unsupported os.name"));
    }

    private static String resolveToolchain(String os) {
        return TargetName.check(os, "Mac OS") ? "none" : "gnu";
    }

    static {
        ARCH = System.getProperty("os.arch");
        EMBED = System.getProperty(LMDB_EMBEDDED_LIB_PROP);
        EXTERNAL = System.getProperty(LMDB_NATIVE_LIB_PROP);
        OS = System.getProperty("os.name");
        IS_EXTERNAL = TargetName.isExternal(EXTERNAL);
        RESOLVED_FILENAME = TargetName.resolveFilename(EXTERNAL, EMBED, ARCH, OS);
    }
}

