/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.application.vela.controller.security;

import cn.sliew.carp.framework.common.security.annotations.AnonymousAccess;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1AdminConfiguredResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1DexConfigResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1GetLoginTypeResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1InitAdminRequest;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1InitAdminResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1LoginRequest;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1LoginResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1LoginUserInfoResponse;
import cn.sliew.carp.module.application.vela.api.v1.model.security.V1RefreshTokenResponse;
import cn.sliew.carp.module.application.vela.api.v1.security.AuthenticationApi;
import cn.sliew.carp.module.application.vela.config.VelaFeignConfig;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@AnonymousAccess
@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/application/vela/auth"})
@Tag(name="\u5e94\u7528\u6a21\u5757-Vela-\u8ba4\u8bc1\u7ba1\u7406")
public class VelaAuthController {
    @Autowired
    private AuthenticationApi authenticationApi;

    @GetMapping(value={"login_type"})
    @Operation(summary="\u767b\u9646\u7c7b\u578b", description="\u767b\u9646\u7c7b\u578b")
    public ResponseEntity<V1GetLoginTypeResponse> getLoginType() {
        return this.authenticationApi.getLoginType(VelaFeignConfig.VELA_URI);
    }

    @GetMapping(value={"user_info"})
    @Operation(summary="\u767b\u9646\u7528\u6237\u4fe1\u606f", description="\u767b\u9646\u7528\u6237\u4fe1\u606f")
    public ResponseEntity<V1LoginUserInfoResponse> getLoginUserInfo() {
        return this.authenticationApi.getLoginUserInfo(VelaFeignConfig.VELA_URI);
    }

    @PostMapping(value={"login"})
    @Operation(summary="\u767b\u9646", description="\u767b\u9646")
    public ResponseEntity<V1LoginResponse> login(@RequestBody V1LoginRequest request) {
        ResponseEntity<V1LoginResponse> responseEntity = this.authenticationApi.login(VelaFeignConfig.VELA_URI, request);
        VelaFeignConfig.VelaOpenAPIAuthInterceptor.setToken(((V1LoginResponse)responseEntity.getBody()).getAccessToken());
        return responseEntity;
    }

    @GetMapping(value={"refreshToken"})
    @Operation(summary="\u5237\u65b0\u6388\u6743", description="\u5237\u65b0\u6388\u6743")
    public ResponseEntity<V1RefreshTokenResponse> refreshToken(@RequestParam(value="refreshToken") String refreshToken) {
        ResponseEntity<V1RefreshTokenResponse> responseEntity = this.authenticationApi.refreshToken(VelaFeignConfig.VELA_URI, refreshToken);
        VelaFeignConfig.VelaOpenAPIAuthInterceptor.setToken(((V1RefreshTokenResponse)responseEntity.getBody()).getAccessToken());
        return responseEntity;
    }

    @GetMapping(value={"admin_configured"})
    @Operation(summary="\u662f\u5426\u914d\u7f6e Admin \u7528\u6237", description="\u662f\u5426\u914d\u7f6e Admin \u7528\u6237")
    public ResponseEntity<V1AdminConfiguredResponse> adminConfigured() {
        return this.authenticationApi.adminConfigured(VelaFeignConfig.VELA_URI);
    }

    @PutMapping(value={"init_admin"})
    @Operation(summary="\u914d\u7f6e Admin \u7528\u6237", description="\u914d\u7f6e Admin \u7528\u6237")
    public ResponseEntity<V1InitAdminResponse> configureAdmin(@RequestBody V1InitAdminRequest request) {
        return this.authenticationApi.configureAdmin(VelaFeignConfig.VELA_URI, request);
    }

    @GetMapping(value={"dex_config"})
    @Operation(summary="dex\u914d\u7f6e", description="dex\u914d\u7f6e")
    public ResponseEntity<V1DexConfigResponse> getDexConfig() {
        return this.authenticationApi.getDexConfig(VelaFeignConfig.VELA_URI);
    }
}

