/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import org.apiguardian.api.API;
import org.zalando.logbook.BodyReplacer;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.RequestFilter;
import org.zalando.logbook.core.BodyReplacementHttpRequest;
import org.zalando.logbook.core.BodyReplacers;
import org.zalando.logbook.core.DefaultFilters;

@API(status=API.Status.STABLE)
public final class RequestFilters {
    private RequestFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static RequestFilter defaultValue() {
        return DefaultFilters.defaultValues(RequestFilter.class).stream().reduce(RequestFilters.replaceBody(BodyReplacers.defaultValue()), RequestFilter::merge);
    }

    public static RequestFilter replaceBody(BodyReplacer<HttpRequest> replacer) {
        return request -> {
            String replacement = replacer.replace((HttpMessage)request);
            if (replacement == null) {
                return request;
            }
            return new BodyReplacementHttpRequest(request, replacement);
        };
    }
}

