/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Exiting$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$Leaving$;
import org.apache.pekko.cluster.MemberStatus$PreparingForShutdown$;
import org.apache.pekko.cluster.MemberStatus$ReadyForShutdown$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.MembershipState$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.util.Version;
import org.apache.pekko.util.Version$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Member$
implements scala.Serializable {
    public static Member$ MODULE$;
    private final Set<Member> none;
    private final Ordering<Address> addressOrdering;
    private final Ordering<Member> leaderStatusOrdering;
    private final Ordering<Member> ordering;
    private final Ordering<Member> ageOrdering;

    static {
        new Member$();
    }

    public Set<Member> none() {
        return this.none;
    }

    @InternalApi
    public Member apply(UniqueAddress uniqueAddress, Set<String> roles, Version appVersion) {
        return new Member(uniqueAddress, Integer.MAX_VALUE, MemberStatus$Joining$.MODULE$, roles, appVersion);
    }

    public Member removed(UniqueAddress node) {
        return new Member(node, Integer.MAX_VALUE, MemberStatus$Removed$.MODULE$, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(ClusterSettings$.MODULE$.DcRolePrefix()).append("-N/A").toString()}))), Version$.MODULE$.Zero());
    }

    public Ordering<Address> addressOrdering() {
        return this.addressOrdering;
    }

    public Ordering<Member> leaderStatusOrdering() {
        return this.leaderStatusOrdering;
    }

    public Ordering<Member> ordering() {
        return this.ordering;
    }

    public Ordering<Member> ageOrdering() {
        return this.ageOrdering;
    }

    public Set<Member> pickHighestPriority(Set<Member> a, Set<Member> b) {
        return this.pickHighestPriority(a, b, (Map<UniqueAddress, Object>)Predef$.MODULE$.Map().empty());
    }

    @InternalApi
    public Set<Member> pickHighestPriority(Set<Member> a, Set<Member> b, Map<UniqueAddress, Object> tombstones) {
        return (Set)((TraversableLike)a.toSeq().$plus$plus((GenTraversableOnce)b.toSeq(), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.uniqueAddress()).foldLeft(this.none(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            Set acc = x0$1;
            Tuple2 tuple22 = x1$1;
            if (tuple22 != null) {
                Seq members = (Seq)tuple22._2();
                if (members.size() == 2) {
                    return (Set)acc.$plus(members.reduceLeft((Function2 & Serializable & scala.Serializable)(m1, m2) -> MODULE$.highestPriorityOf((Member)m1, (Member)m2)));
                }
                Member m = (Member)members.head();
                if (tombstones.contains((Object)m.uniqueAddress()) || MembershipState$.MODULE$.removeUnreachableWithMemberStatus().apply((Object)m.status())) {
                    return acc;
                }
                return (Set)acc.$plus((Object)m);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Member highestPriorityOf(Member m1, Member m2) {
        MemberStatus memberStatus = m1.status();
        MemberStatus memberStatus2 = m2.status();
        if (!(memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null)) {
            if (m1.isOlderThan(m2)) {
                return m1;
            }
            return m2;
        }
        MemberStatus memberStatus3 = m2.status();
        MemberStatus memberStatus4 = m1.status();
        Tuple2 tuple2 = new Tuple2((Object)memberStatus4, (Object)memberStatus3);
        if (MemberStatus$Removed$.MODULE$.equals(memberStatus4)) {
            return m1;
        }
        if (MemberStatus$Removed$.MODULE$.equals(memberStatus3)) {
            return m2;
        }
        if (MemberStatus$ReadyForShutdown$.MODULE$.equals(memberStatus4)) {
            return m1;
        }
        if (MemberStatus$ReadyForShutdown$.MODULE$.equals(memberStatus3)) {
            return m2;
        }
        if (MemberStatus$Down$.MODULE$.equals(memberStatus4)) {
            return m1;
        }
        if (MemberStatus$Down$.MODULE$.equals(memberStatus3)) {
            return m2;
        }
        if (MemberStatus$Exiting$.MODULE$.equals(memberStatus4)) {
            return m1;
        }
        if (MemberStatus$Exiting$.MODULE$.equals(memberStatus3)) {
            return m2;
        }
        if (MemberStatus$Leaving$.MODULE$.equals(memberStatus4)) {
            return m1;
        }
        if (MemberStatus$Leaving$.MODULE$.equals(memberStatus3)) {
            return m2;
        }
        if (tuple2 != null && MemberStatus$Joining$.MODULE$.equals(memberStatus4)) {
            return m2;
        }
        if (tuple2 != null && MemberStatus$Joining$.MODULE$.equals(memberStatus3)) {
            return m1;
        }
        if (tuple2 != null && MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus4)) {
            return m2;
        }
        if (tuple2 != null && MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus3)) {
            return m1;
        }
        if (tuple2 != null && MemberStatus$PreparingForShutdown$.MODULE$.equals(memberStatus4)) {
            return m1;
        }
        if (tuple2 != null && MemberStatus$PreparingForShutdown$.MODULE$.equals(memberStatus3)) {
            return m2;
        }
        if (tuple2 != null && MemberStatus$Up$.MODULE$.equals(memberStatus4) && MemberStatus$Up$.MODULE$.equals(memberStatus3)) {
            return m1;
        }
        throw new MatchError((Object)tuple2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$addressOrdering$1(Address a, Address b) {
        if (a == b) {
            return false;
        }
        Option option = a.host();
        Option option2 = b.host();
        if (option == null ? option2 != null : !option.equals(option2)) {
            return ((String)a.host().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).compareTo((String)b.host().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")) < 0;
        }
        Option option3 = a.port();
        Option option4 = b.port();
        if (option3 == null ? option4 != null : !option3.equals(option4)) {
            return BoxesRunTime.unboxToInt((Object)a.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) < BoxesRunTime.unboxToInt((Object)b.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$leaderStatusOrdering$1(Member a, Member b) {
        MemberStatus memberStatus;
        MemberStatus memberStatus2 = b.status();
        MemberStatus memberStatus3 = memberStatus = a.status();
        if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus2) : memberStatus2 != null)) {
            return MODULE$.ordering().compare((Object)a, (Object)b) <= 0;
        }
        if (MemberStatus$Down$.MODULE$.equals(memberStatus)) {
            return false;
        }
        if (MemberStatus$Down$.MODULE$.equals(memberStatus2)) {
            return true;
        }
        if (MemberStatus$Exiting$.MODULE$.equals(memberStatus)) {
            return false;
        }
        if (MemberStatus$Exiting$.MODULE$.equals(memberStatus2)) {
            return true;
        }
        if (MemberStatus$Joining$.MODULE$.equals(memberStatus)) {
            return false;
        }
        if (MemberStatus$Joining$.MODULE$.equals(memberStatus2)) {
            return true;
        }
        if (MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus)) {
            return false;
        }
        if (MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus2)) {
            return true;
        }
        return MODULE$.ordering().compare((Object)a, (Object)b) <= 0;
    }

    private Member$() {
        MODULE$ = this;
        this.none = Predef$.MODULE$.Set().empty();
        this.addressOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)Member$.$anonfun$addressOrdering$1(a, b)));
        this.leaderStatusOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)Member$.$anonfun$leaderStatusOrdering$1(a, b)));
        this.ordering = new Ordering<Member>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Member> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Member> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(Member a, Member b) {
                return a.uniqueAddress().compare(b.uniqueAddress());
            }
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
        this.ageOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)a.isOlderThan(b)));
    }
}

