/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.exception.convertor;

import cn.sliew.carp.framework.common.model.ResponseVO;
import cn.sliew.carp.framework.web.exception.convertor.ExceptionConvertor;
import cn.sliew.carp.framework.web.util.RequestParamUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;

public class BindExceptionConvertor
implements ExceptionConvertor<BindException> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BindExceptionConvertor.class);

    @Override
    public ResponseVO convert(BindException exception, HttpServletRequest request, HttpServletResponse response) {
        String params = RequestParamUtil.formatRequestParams(request);
        log.error("{} {} {}", new Object[]{request.getMethod(), request.getRequestURI(), params, exception});
        StringBuilder sb = new StringBuilder();
        for (FieldError fieldError : exception.getFieldErrors()) {
            String message = String.format("server reject [%s] value [%s] with rules: %s;", fieldError.getField(), fieldError.getRejectedValue(), fieldError.getDefaultMessage());
            sb.append(message);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return ResponseVO.error((String)sb.toString());
    }
}

