/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.util;

import cn.sliew.milky.common.util.JacksonUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

@Component
public class RequestParamUtil {
    private static String contextPath;
    private static final String IGNORE_CONTENT_TYPE = "multipart/form-data";
    private static List<String> DEFAULT_IGNORE_PATH;
    private static List<String> IGNORE_PATH;
    private static final AntPathMatcher ANT_PATH_MATCHER;

    public RequestParamUtil(@Value(value="${server.servlet.context-path}") String contextPath) {
        RequestParamUtil.contextPath = contextPath;
        IGNORE_PATH = RequestParamUtil.getIgnorePaths();
    }

    public static String formatRequestParams(HttpServletRequest request) {
        StringBuilder params = new StringBuilder();
        if (!RequestParamUtil.ignoreContentType(request.getContentType())) {
            String body;
            String parameters = RequestParamUtil.getRequestParams(request);
            if (StringUtils.hasText((String)parameters)) {
                params.append("uri_params: [");
                params.append(parameters);
                params.append("]");
            }
            if (StringUtils.hasText((String)(body = RequestParamUtil.getRequestBody(request)))) {
                if (params.length() != 0) {
                    params.append(", request_body: [");
                } else {
                    params.append("request_body: [");
                }
                params.append(body);
                params.append("]");
            }
        }
        return params.toString();
    }

    public static String getRequestParams(HttpServletRequest request) {
        if (request.getParameterMap().isEmpty()) {
            return "";
        }
        HashMap<String, Object> query = new HashMap<String, Object>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String key = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (value == null || value.length == 0) {
                query.put(key, null);
                continue;
            }
            if (value.length == 1) {
                query.put(key, value[0]);
                continue;
            }
            query.put(key, value);
        }
        return JacksonUtil.toJsonString(query);
    }

    public static String getRequestBody(HttpServletRequest request) {
        byte[] buf;
        ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
        if (wrapper != null && (buf = wrapper.getContentAsByteArray()).length > 0) {
            String payload;
            try {
                payload = new String(buf, 0, buf.length, wrapper.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                payload = "[unknown]";
            }
            return payload.replaceAll("\\n", "");
        }
        return "";
    }

    public static boolean isRequestValid(HttpServletRequest request) {
        try {
            new URI(request.getRequestURL().toString());
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    public static boolean ignorePath(String uri) {
        return IGNORE_PATH.stream().filter(pattern -> ANT_PATH_MATCHER.match(pattern, uri)).findAny().isPresent();
    }

    public static boolean ignoreContentType(String contentType) {
        return StringUtils.hasText((String)contentType) && contentType.startsWith(IGNORE_CONTENT_TYPE);
    }

    public static List<String> getIgnorePaths() {
        if (CollectionUtils.isEmpty(IGNORE_PATH) && StringUtils.hasText((String)contextPath)) {
            IGNORE_PATH = RequestParamUtil.getDefaultIgnorePaths().stream().map(path -> "/" + contextPath + path).collect(Collectors.toList());
        }
        return IGNORE_PATH;
    }

    public static List<String> getDefaultIgnorePaths() {
        return DEFAULT_IGNORE_PATH;
    }

    static {
        DEFAULT_IGNORE_PATH = Arrays.asList("/doc.html", "/swagger-resources", "/webjars/**", "/v3/api-docs/**", "/favicon.ico", "/ui/**/**");
        IGNORE_PATH = Collections.emptyList();
        ANT_PATH_MATCHER = new AntPathMatcher();
    }
}

