/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.ClientHandler;
import org.apache.pekko.remote.transport.netty.NettyFutureBridge$;
import org.apache.pekko.remote.transport.netty.NettySSLSupport$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.NettyTransportException;
import org.apache.pekko.remote.transport.netty.NettyTransportExceptionNoStack;
import org.apache.pekko.remote.transport.netty.NettyTransportSettings;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.TcpClientHandler;
import org.apache.pekko.remote.transport.netty.TcpServerHandler;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rMqA\u0002\u001e<\u0011\u0003itI\u0002\u0004Jw!\u0005QH\u0013\u0005\u0006#\u0006!\ta\u0015\u0005\b)\u0006\u0011\r\u0011\"\u0001V\u0011\u0019I\u0016\u0001)A\u0005-\")!,\u0001C\u00017\"9!/\u0001b\u0001\n\u0003\u0019\bBB@\u0002A\u0003%A\u000fC\u0004\u0002\u0002\u0005!\t!a\u0001\t\u000f\u0005\u0005\u0011\u0001\"\u0001\u0002R\u0019)\u0011j\u000f\u0001\u0002l!Q\u0011Q\u000f\u0006\u0003\u0006\u0004%\t!a\u001e\t\u0015\u0005}$B!A!\u0002\u0013\tI\b\u0003\u0006\u0002\u0002*\u0011)\u0019!C\u0001\u0003\u0007C!\"a#\u000b\u0005\u0003\u0005\u000b\u0011BAC\u0011\u0019\t&\u0002\"\u0001\u0002\u000e\"1\u0011K\u0003C\u0001\u0003+C\u0011\"!-\u000b\u0005\u0004%\u0019!a-\t\u000f\u0005U&\u0002)A\u0005E\"I\u0011\u0011\u0006\u0006C\u0002\u0013\u0005\u0013q\u0017\u0005\t\u0003sS\u0001\u0015!\u0003\u0002,!1\u00111\u0018\u0006\u0005BUC1\"!0\u000b\u0001\u0004\u0005\r\u0011\"\u0003\u0002@\"Y\u0011\u0011\u0019\u0006A\u0002\u0003\u0007I\u0011BAb\u0011-\tIM\u0003a\u0001\u0002\u0003\u0006K!a\u0003\t\u0017\u0005M'\u00021AA\u0002\u0013%\u0011Q\u001b\u0005\f\u0003/T\u0001\u0019!a\u0001\n\u0013\tI\u000e\u0003\u0006\u0002^*\u0001\r\u0011!Q!\n)D\u0011\"!9\u000b\u0005\u0004%I!a9\t\u0011\u0005E(\u0002)A\u0005\u0003KDq!a=\u000b\t\u0013\t)\u0010C\u0005\u0003\b)\u0011\r\u0011\"\u0001\u0003\n!A!q\u0003\u0006!\u0002\u0013\u0011Y\u0001C\u0005\u0003\u001a)\u0011\r\u0011\"\u0003\u0003\u001c!A!Q\u0004\u0006!\u0002\u0013\t9\u0010C\u0005\u0003 )\u0011\r\u0011\"\u0003\u0003\u001c!A!\u0011\u0005\u0006!\u0002\u0013\t9\u0010C\u0005\u0003$)\u0011\r\u0011\"\u0003\u0003\u001c!A!Q\u0005\u0006!\u0002\u0013\t9\u0010C\u0004\u0003()!IA!\u000b\t\u0013\tM\"B1A\u0005\n\tU\u0002\u0002\u0003B-\u0015\u0001\u0006IAa\u000e\t\u0013\tm#B1A\u0005\n\tu\u0003\u0002\u0003B8\u0015\u0001\u0006IAa\u0018\t\u000f\tE$\u0002\"\u0003\u0003t!I!q\u0012\u0006C\u0002\u0013%!\u0011\u0013\u0005\t\u0005KS\u0001\u0015!\u0003\u0003\u0014\"9!q\u0015\u0006\u0005\n\t%\u0006\"\u0003BX\u0015\t\u0007I\u0011\u0002BY\u0011!\u0011yL\u0003Q\u0001\n\tM\u0006b\u0002Ba\u0015\u0011%!1\u0019\u0005\b\u0005\u001bTA\u0011\tBh\u0011\u001d\u0011)N\u0003C\u0001\u0005/DqAa:\u000b\t\u0003\u0012I\u000f\u0003\u0005\u0003t*!\t!QA`\u0011\u001d\u0011)P\u0003C\u0005\u0005oDqA!@\u000b\t\u0003\u0012y\u0010C\u0004\u0004\f)!\te!\u0004\u0002\u001d9+G\u000f^=Ue\u0006t7\u000f]8si*\u0011A(P\u0001\u0006]\u0016$H/\u001f\u0006\u0003}}\n\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u0001\u000b\u0015A\u0002:f[>$XM\u0003\u0002C\u0007\u0006)\u0001/Z6l_*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h!\tA\u0015!D\u0001<\u00059qU\r\u001e;z)J\fgn\u001d9peR\u001c\"!A&\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A$\u0002-\u0019\u0013\u0018-\\3MK:<G\u000f\u001b$jK2$G*\u001a8hi\",\u0012A\u0016\t\u0003\u0019^K!\u0001W'\u0003\u0007%sG/A\fGe\u0006lW\rT3oORDg)[3mI2+gn\u001a;iA\u0005iqM]1dK\u001a,Hn\u00117pg\u0016$\"\u0001\u00185\u0015\u0005u\u0003\u0007C\u0001'_\u0013\tyVJ\u0001\u0003V]&$\b\"B1\u0006\u0001\b\u0011\u0017AA3d!\t\u0019g-D\u0001e\u0015\t)W*\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001a3\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B5\u0006\u0001\u0004Q\u0017aB2iC:tW\r\u001c\t\u0003WBl\u0011\u0001\u001c\u0006\u0003S6T!\u0001\u00108\u000b\u0003=\f!![8\n\u0005Ed'aB\"iC:tW\r\\\u0001\u0010k:L\u0017/^3JI\u000e{WO\u001c;feV\tA\u000f\u0005\u0002v{6\taO\u0003\u0002xq\u00061\u0011\r^8nS\u000eT!!Z=\u000b\u0005i\\\u0018\u0001B;uS2T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fm\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\f\u0001#\u001e8jcV,\u0017\nZ\"pk:$XM\u001d\u0011\u00021\u0005$GM]3tg\u001a\u0013x.\\*pG.,G/\u00113ee\u0016\u001c8\u000f\u0006\u0007\u0002\u0006\u0005]\u0011qEA!\u0003\u000b\nY\u0005E\u0003M\u0003\u000f\tY!C\u0002\u0002\n5\u0013aa\u00149uS>t\u0007\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0011)A\u0003bGR|'/\u0003\u0003\u0002\u0016\u0005=!aB!eIJ,7o\u001d\u0005\b\u00033A\u0001\u0019AA\u000e\u0003\u0011\tG\r\u001a:\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t|\u0003\rqW\r^\u0005\u0005\u0003K\tyBA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\b\u0003SA\u0001\u0019AA\u0016\u0003A\u00198\r[3nK&#WM\u001c;jM&,'\u000f\u0005\u0003\u0002.\u0005mb\u0002BA\u0018\u0003o\u00012!!\rN\u001b\t\t\u0019DC\u0002\u00026I\u000ba\u0001\u0010:p_Rt\u0014bAA\u001d\u001b\u00061\u0001K]3eK\u001aLA!!\u0010\u0002@\t11\u000b\u001e:j]\u001eT1!!\u000fN\u0011\u001d\t\u0019\u0005\u0003a\u0001\u0003W\t!b]=ti\u0016lg*Y7f\u0011\u001d\t9\u0005\u0003a\u0001\u0003\u0013\n\u0001\u0002[8ti:\u000bW.\u001a\t\u0006\u0019\u0006\u001d\u00111\u0006\u0005\b\u0003\u001bB\u0001\u0019AA(\u0003\u0011\u0001xN\u001d;\u0011\t1\u000b9A\u0016\u000b\u000b\u0003\u000b\t\u0019&!\u0016\u0002X\u0005e\u0003bBA\r\u0013\u0001\u0007\u00111\u0004\u0005\b\u0003SI\u0001\u0019AA\u0016\u0011\u001d\t\u0019%\u0003a\u0001\u0003WAq!a\u0012\n\u0001\u0004\tI\u0005K\u0004\u0002\u0003;\n\u0019'a\u001a\u0011\u00071\u000by&C\u0002\u0002b5\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\t)'\u0001\u0016DY\u0006\u001c8/[2!e\u0016lw\u000e^5oO\u0002J7\u000f\t3faJ,7-\u0019;fI2\u0002So]3!\u0003J$XM]=\"\u0005\u0005%\u0014AC!lW\u0006\u0004#G\f\u001c/aM!!bSA7!\u0011\ty'!\u001d\u000e\u0003uJ1!a\u001d>\u0005%!&/\u00198ta>\u0014H/\u0001\u0005tKR$\u0018N\\4t+\t\tI\bE\u0002I\u0003wJ1!! <\u0005YqU\r\u001e;z)J\fgn\u001d9peR\u001cV\r\u001e;j]\u001e\u001c\u0018!C:fiRLgnZ:!\u0003\u0019\u0019\u0018p\u001d;f[V\u0011\u0011Q\u0011\t\u0005\u0003\u001b\t9)\u0003\u0003\u0002\n\u0006=!aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000e\t\u000b\u0007\u0003\u001f\u000b\t*a%\u0011\u0005!S\u0001bBA;\u001f\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u0003{\u0001\u0019AAC)\u0019\ty)a&\u0002\u001a\"9\u0011\u0011\u0011\tA\u0002\u0005\u0015\u0005bBAN!\u0001\u0007\u0011QT\u0001\u0005G>tg\r\u0005\u0003\u0002 \u00065VBAAQ\u0015\u0011\t\u0019+!*\u0002\r\r|gNZ5h\u0015\u0011\t9+!+\u0002\u0011QL\b/Z:bM\u0016T!!a+\u0002\u0007\r|W.\u0003\u0003\u00020\u0006\u0005&AB\"p]\u001aLw-\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\t!-A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002*\"!a\u000b\u0002#M\u001c\u0007.Z7f\u0013\u0012,g\u000e^5gS\u0016\u0014\b%A\nnCbLW.^7QCfdw.\u00193CsR,7/A\u0004c_VtG\rV8\u0016\u0005\u0005-\u0011a\u00032pk:$Gk\\0%KF$2!XAc\u0011%\t9mFA\u0001\u0002\u0004\tY!A\u0002yIE\n\u0001BY8v]\u0012$v\u000e\t\u0015\u00041\u00055\u0007c\u0001'\u0002P&\u0019\u0011\u0011['\u0003\u0011Y|G.\u0019;jY\u0016\fQb]3sm\u0016\u00148\t[1o]\u0016dW#\u00016\u0002#M,'O^3s\u0007\"\fgN\\3m?\u0012*\u0017\u000fF\u0002^\u00037D\u0001\"a2\u001b\u0003\u0003\u0005\rA[\u0001\u000fg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7!Q\rY\u0012QZ\u0001\u0004Y><WCAAs!\u0011\t9/!<\u000e\u0005\u0005%(bAAv\u0003\u0006)QM^3oi&!\u0011q^Au\u0005Qi\u0015M]6fe2{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006!An\\4!\u0003Q\u0019'/Z1uK\u00163XM\u001c;M_>\u0004xI]8vaR!\u0011q\u001fB\u0002!\u0011\tI0a@\u000e\u0005\u0005m(bAA\u007fY\u0006\u0019a.[8\n\t\t\u0005\u00111 \u0002\u0012\u001d&|WI^3oi2{w\u000e]$s_V\u0004\bB\u0002B\u0003=\u0001\u0007a+\u0001\u0007o)\"\u0014X-\u00193D_VtG/\u0001\u0007dQ\u0006tg.\u001a7He>,\b/\u0006\u0002\u0003\fA!!Q\u0002B\n\u001b\t\u0011yAC\u0002\u0003\u00121\fQa\u001a:pkBLAA!\u0006\u0003\u0010\t\u0019B)\u001a4bk2$8\t[1o]\u0016dwI]8va\u0006i1\r[1o]\u0016dwI]8va\u0002\nAc\u00197jK:$XI^3oi2{w\u000e]$s_V\u0004XCAA|\u0003U\u0019G.[3oi\u00163XM\u001c;M_>\u0004xI]8va\u0002\n!d]3sm\u0016\u0014XI^3oi2{w\u000e\u001d)be\u0016tGo\u0012:pkB\f1d]3sm\u0016\u0014XI^3oi2{w\u000e\u001d)be\u0016tGo\u0012:pkB\u0004\u0013!G:feZ,'/\u0012<f]Rdun\u001c9DQ&dGm\u0012:pkB\f!d]3sm\u0016\u0014XI^3oi2{w\u000e]\"iS2$wI]8va\u0002\n1B\\3x!&\u0004X\r\\5oKR!!1\u0006B\u0019!\rY'QF\u0005\u0004\u0005_a'aD\"iC:tW\r\u001c)ja\u0016d\u0017N\\3\t\u000b%<\u0003\u0019\u00016\u00025\u0005\u001c8o\\2jCRLwN\u001c'jgR,g.\u001a:Qe>l\u0017n]3\u0016\u0005\t]\u0002#B2\u0003:\tu\u0012b\u0001B\u001eI\n9\u0001K]8nSN,\u0007\u0003\u0002B \u0005'rAA!\u0011\u0003P9!!1\tB'\u001d\u0011\u0011)Ea\u0013\u000f\t\t\u001d#\u0011J\u0007\u0002\u0007&\u0011!iQ\u0005\u0003\u0001\u0006K!AP \n\u0007\tES(A\u0005Ue\u0006t7\u000f]8si&!!Q\u000bB,\u0005a\t5o]8dS\u0006$\u0018n\u001c8Fm\u0016tG\u000fT5ti\u0016tWM\u001d\u0006\u0004\u0005#j\u0014aG1tg>\u001c\u0017.\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bK]8nSN,\u0007%A\ttg2,enZ5oKB\u0013xN^5eKJ,\"Aa\u0018\u0011\r\t\u0005$Q\rB5\u001b\t\u0011\u0019G\u0003\u0002{\u0003&!!q\rB2\u0005%y\u0005\u000f^5p]Z\u000bG\u000eE\u0002I\u0005WJ1A!\u001c<\u0005E\u00196\u000bT#oO&tW\r\u0015:pm&$WM]\u0001\u0013gNdWI\\4j]\u0016\u0004&o\u001c<jI\u0016\u0014\b%\u0001\u0006tg2D\u0015M\u001c3mKJ$BA!\u001e\u0003\u0006B!!q\u000fBA\u001b\t\u0011IH\u0003\u0003\u0003|\tu\u0014aA:tY*\u0019!qP7\u0002\u000f!\fg\u000e\u001a7fe&!!1\u0011B=\u0005)\u00196\u000f\u001c%b]\u0012dWM\u001d\u0005\b\u0005\u000fc\u0003\u0019\u0001BE\u0003!I7o\u00117jK:$\bc\u0001'\u0003\f&\u0019!QR'\u0003\u000f\t{w\u000e\\3b]\u0006I2/\u001a:wKJ\u0004\u0016\u000e]3mS:,\u0017J\\5uS\u0006d\u0017N_3s+\t\u0011\u0019\nE\u0003l\u0005+\u0013I*C\u0002\u0003\u00182\u0014!c\u00115b]:,G.\u00138ji&\fG.\u001b>feB!!1\u0014BQ\u001b\t\u0011iJC\u0002\u0003 2\faa]8dW\u0016$\u0018\u0002\u0002BR\u0005;\u0013QbU8dW\u0016$8\t[1o]\u0016d\u0017AG:feZ,'\u000fU5qK2Lg.Z%oSRL\u0017\r\\5{KJ\u0004\u0013!G2mS\u0016tG\u000fU5qK2Lg.Z%oSRL\u0017\r\\5{KJ$BAa%\u0003,\"9!QV\u0018A\u0002\u0005-\u0011!\u0004:f[>$X-\u00113ee\u0016\u001c8/\u0001\tj]\n|WO\u001c3C_>$8\u000f\u001e:baV\u0011!1\u0017\t\u0005\u0005k\u0013Y,\u0004\u0002\u00038*\u0019!\u0011X7\u0002\u0013\t|w\u000e^:ue\u0006\u0004\u0018\u0002\u0002B_\u0005o\u0013qbU3sm\u0016\u0014(i\\8ugR\u0014\u0018\r]\u0001\u0012S:\u0014w.\u001e8e\u0005>|Go\u001d;sCB\u0004\u0013!E8vi\n|WO\u001c3C_>$8\u000f\u001e:baR!!Q\u0019Bf!\u0011\u0011)La2\n\t\t%'q\u0017\u0002\n\u0005>|Go\u001d;sCBDqA!,3\u0001\u0004\tY!\u0001\tjgJ+7\u000f]8og&\u0014G.\u001a$peR!!\u0011\u0012Bi\u0011\u001d\u0011\u0019n\ra\u0001\u0003\u0017\tq!\u00193ee\u0016\u001c8/\u0001\fbI\u0012\u0014Xm]:U_N{7m[3u\u0003\u0012$'/Z:t)\u0011\u0011IN!:\u0011\u000b\r\u0014YNa8\n\u0007\tuGM\u0001\u0004GkR,(/\u001a\t\u0005\u0003;\u0011\t/\u0003\u0003\u0003d\u0006}!!E%oKR\u001cvnY6fi\u0006#GM]3tg\"9\u0011\u0011\u0004\u001bA\u0002\u0005-\u0011A\u00027jgR,g.\u0006\u0002\u0003lB)1Ma7\u0003nB9AJa<\u0002\f\t]\u0012b\u0001By\u001b\n1A+\u001e9mKJ\nABY8v]\u0012\fE\r\u001a:fgN\f!#\u001a=ue\u0006\u001cG\u000fS8ti\u0006sG\rU8siR!!\u0011 B~!\u0019a%q^A\u0016-\"9\u0011\u0011D\u001cA\u0002\u0005-\u0011!C1tg>\u001c\u0017.\u0019;f)\u0011\u0019\ta!\u0003\u0011\u000b\r\u0014Yna\u0001\u0011\t\u0005=4QA\u0005\u0004\u0007\u000fi$!E!tg>\u001c\u0017.\u0019;j_:D\u0015M\u001c3mK\"9!Q\u0016\u001dA\u0002\u0005-\u0011\u0001C:ikR$wn\u001e8\u0015\u0005\r=\u0001#B2\u0003\\\n%\u0005f\u0002\u0006\u0002^\u0005\r\u0014q\r")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter log;
    private final DefaultChannelGroup channelGroup;
    private final NioEventLoopGroup clientEventLoopGroup;
    private final NioEventLoopGroup serverEventLoopParentGroup;
    private final NioEventLoopGroup serverEventLoopChildGroup;
    private final Promise<Transport.AssociationEventListener> associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelInitializer<SocketChannel> serverPipelineInitializer;
    private final ServerBootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress socketAddress, String string, String string2, Option<String> option, Option<Object> option2) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(socketAddress, string, string2, option, option2);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext executionContext) {
        NettyTransport$.MODULE$.gracefulClose(channel, executionContext);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    private NioEventLoopGroup createEventLoopGroup(int nThreadCount) {
        return (NioEventLoopGroup)this.settings().UseDispatcherForIo().map(arg_0 -> NettyTransport.$anonfun$createEventLoopGroup$1(this.system().dispatchers(), arg_0)).map((Function1 & Serializable & scala.Serializable)executor -> new NioEventLoopGroup(0, (Executor)executor)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new NioEventLoopGroup(nThreadCount, this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private NioEventLoopGroup clientEventLoopGroup() {
        return this.clientEventLoopGroup;
    }

    private NioEventLoopGroup serverEventLoopParentGroup() {
        return this.serverEventLoopParentGroup;
    }

    private NioEventLoopGroup serverEventLoopChildGroup() {
        return this.serverEventLoopChildGroup;
    }

    private ChannelPipeline newPipeline(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("FlushConsolidationHandler", (ChannelHandler)new FlushConsolidationHandler(256, true));
        pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    private Promise<Transport.AssociationEventListener> associationListenerPromise() {
        return this.associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    private SslHandler sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        SSLEngineProvider sSLEngineProvider2 = (SSLEngineProvider)OptionVal.Some$.MODULE$.unapply((Object)sSLEngineProvider);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider2)) {
            SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider2);
            return NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelInitializer<SocketChannel> serverPipelineInitializer() {
        return this.serverPipelineInitializer;
    }

    private ChannelInitializer<SocketChannel> clientPipelineInitializer(Address remoteAddress) {
        return new ChannelInitializer<SocketChannel>(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            public final void initChannel(SocketChannel x$1) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$clientPipelineInitializer$1(x$1, this.remoteAddress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private ServerBootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    private Bootstrap outboundBootstrap(Address remoteAddress) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)this.clientEventLoopGroup());
        bootstrap.handler(this.clientPipelineInitializer(remoteAddress));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Predef$.MODULE$.int2Integer((int)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpNodelay()));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1 & Serializable & scala.Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$1(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().SendBufferSize().foreach((Function1 & Serializable & scala.Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$2(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0).foreach((Function1 & Serializable & scala.Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$4(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 > 0).foreach((Function1 & Serializable & scala.Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$6(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        if (addr != null) {
            Option option = addr.host();
            Option option2 = addr.port();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            try {
                Address address;
                Channel newServerChannel = this.inboundBootstrap().bind(this.settings().BindHostname(), bindPort).sync().channel();
                newServerChannel.config().setAutoRead(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                None$ port = this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)port);
                if (option instanceof Some) {
                    address = (Address)((Some)option).value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Address address2 = (Address)((Some)option2).value();
                    this.boundTo_$eq(address2);
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.associationListenerPromise().future().foreach((Function1 & Serializable & scala.Serializable)x$6 -> newServerChannel.config().setAutoRead(true), this.executionContext());
                tuple2 = new Tuple2((Object)address, this.associationListenerPromise());
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable e;
                    block10: {
                        e = (Throwable)option.get();
                        this.log().error("failed to bind to host:{} port:{}, shutting down Netty transport", (Object)this.settings().BindHostname(), (Object)BoxesRunTime.boxToInteger((int)bindPort));
                        try {
                            this.shutdown();
                        }
                        catch (Throwable throwable2) {
                            if (!NonFatal$.MODULE$.unapply(throwable2).isEmpty()) break block10;
                            throw throwable2;
                        }
                    }
                    throw e;
                }
                throw throwable;
            }
            return tuple2;
        }));
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    private Tuple2<String, Object> extractHostAndPort(Address addr) {
        if (addr != null) {
            Option option = addr.host();
            Option option2 = addr.port();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString());
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel().isActive()) {
            return Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        }
        Bootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.extractHostAndPort(remoteAddress))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$associate$2(check$ifrefutable$1)), this.executionContext()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            if (x$7 != null) {
                String host = (String)x$7._1();
                int port = x$7._2$mcI$sp();
                return NettyFutureBridge$.MODULE$.apply(bootstrap.connect(host, port)).flatMap((Function1 & Serializable & scala.Serializable)channel -> (this.settings().EnableSsl() ? NettyFutureBridge$.MODULE$.apply(((SslHandler)channel.pipeline().get(SslHandler.class)).handshakeFuture()) : Future$.MODULE$.successful(channel)).flatMap((Function1 & Serializable & scala.Serializable)readyChannel -> ((ClientHandler)readyChannel.pipeline().get(ClientHandler.class)).statusFuture().map((Function1 & Serializable & scala.Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext());
            }
            throw new MatchError(null);
        }, this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                Option option = NonFatal$.MODULE$.unapply(x1);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    String msg = t.getCause() == null ? t.getMessage() : (t.getCause().getCause() == null ? new StringBuilder(13).append(t.getMessage()).append(", caused by: ").append(t.getCause()).toString() : new StringBuilder(26).append(t.getMessage()).append(", caused by: ").append(t.getCause()).append(", caused by: ").append(t.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(t.getClass().getName()).append(": ").append(msg).toString(), t.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof CancellationException) {
                    return true;
                }
                return !NonFatal$.MODULE$.unapply(x1).isEmpty();
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().close(ChannelMatchers.isServerChannel())).flatMap((Function1 & Serializable & scala.Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ MessageDispatcher $anonfun$executionContext$2(Dispatchers eta$0$1$1, String id) {
        return eta$0$1$1.lookup(id);
    }

    public static final /* synthetic */ MessageDispatcher $anonfun$createEventLoopGroup$1(Dispatchers eta$0$1$2, String id) {
        return eta$0$1$2.lookup(id);
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$serverPipelineInitializer$1(SocketChannel ch) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (this.settings().EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(false));
        }
        TcpServerHandler handler = new TcpServerHandler(this, (Future<Transport.AssociationEventListener>)this.associationListenerPromise().future(), (LoggingAdapter)this.log());
        pipeline.addLast("ServerHandler", (ChannelHandler)handler);
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$clientPipelineInitializer$1(SocketChannel ch, Address remoteAddress$1) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (this.settings().EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(true));
        }
        TcpClientHandler handler = new TcpClientHandler(this, remoteAddress$1, (LoggingAdapter)this.log());
        pipeline.addLast("clienthandler", (ChannelHandler)handler);
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$1(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$2(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$4(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$6(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ boolean $anonfun$associate$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$8) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$8)), this.executionContext()).recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                return (B1)BoxesRunTime.boxToBoolean((boolean)false);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return true;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        $this.clientEventLoopGroup().shutdownGracefully();
        $this.serverEventLoopParentGroup().shutdownGracefully();
        $this.serverEventLoopChildGroup().shutdownGracefully();
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable & scala.Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable & scala.Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().writeAndFlush((Object)Unpooled.EMPTY_BUFFER)).flatMap((Function1 & Serializable & scala.Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    /*
     * WARNING - void declaration
     */
    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        void var3_3;
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        Transport.$init$(this);
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = ((RARP)RARP$.MODULE$.apply((ActorSystem)this.system())).provider().remoteSettings().Dispatcher();
            if ("".equals(string)) {
                return None$.MODULE$;
            }
            return new Some((Object)string);
        }).map(arg_0 -> NettyTransport.$anonfun$executionContext$2(system.dispatchers(), arg_0)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, NettyTransport.class, LogSource$.MODULE$.fromAnyClass());
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(42).append("pekko-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString(), (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.clientEventLoopGroup = this.createEventLoopGroup(settings.ClientSocketWorkerPoolSize() + 1);
        this.serverEventLoopParentGroup = this.createEventLoopGroup(0);
        this.serverEventLoopChildGroup = this.createEventLoopGroup(settings.ServerSocketWorkerPoolSize());
        this.associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)OptionVal.Some$.MODULE$.apply(system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get());
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineInitializer = new ChannelInitializer<SocketChannel>(this){
            private final /* synthetic */ NettyTransport $outer;

            public final void initChannel(SocketChannel x$1) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$serverPipelineInitializer$1(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)this.serverEventLoopParentGroup(), (EventLoopGroup)this.serverEventLoopChildGroup());
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler(this.serverPipelineInitializer());
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)Predef$.MODULE$.int2Integer(settings.Backlog()));
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpReuseAddr()));
        bootstrap.childOption(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpNodelay()));
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpKeepalive()));
        settings.ReceiveBufferSize().foreach((Function1 & Serializable & scala.Serializable)sz -> bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.SendBufferSize().foreach((Function1 & Serializable & scala.Serializable)sz -> bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0).foreach((Function1 & Serializable & scala.Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 > 0).foreach((Function1 & Serializable & scala.Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        this.inboundBootstrap = var3_3;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

