/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.jackson.sensitive;

import cn.sliew.carp.framework.common.jackson.sensitive.Sensitive;
import cn.sliew.carp.framework.common.jackson.sensitive.SensitiveType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;

public class SensitiveJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private SensitiveType type;
    private String strategy;
    private String param;

    public void serialize(String value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeString(this.type.apply(value, this.strategy, this.param));
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Sensitive annotation = (Sensitive)property.getAnnotation(Sensitive.class);
        if (Objects.nonNull(annotation) && Objects.equals(String.class, property.getType().getRawClass())) {
            this.type = annotation.type();
            this.strategy = annotation.strategy();
            this.param = annotation.param();
            return this;
        }
        return provider.findValueSerializer(property.getType(), property);
    }
}

