/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.aggregate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.redisson.api.search.aggregate.Expression;
import org.redisson.api.search.aggregate.GroupBy;
import org.redisson.api.search.aggregate.GroupParams;
import org.redisson.api.search.aggregate.SortedField;

public final class AggregationOptions {
    private boolean verbatim;
    private List<String> load = Collections.emptyList();
    private Long timeout;
    private boolean loadAll;
    private List<GroupParams> groupByParams = Collections.emptyList();
    private List<SortedField> sortedByFields = Collections.emptyList();
    private Integer sortedByMax;
    private List<Expression> expressions = Collections.emptyList();
    private Integer offset;
    private Integer count;
    private String filter;
    private boolean withCursor;
    private Integer cursorCount;
    private Integer cursorMaxIdle;
    private Map<String, Object> params = Collections.emptyMap();
    private Integer dialect;

    private AggregationOptions() {
    }

    public static AggregationOptions defaults() {
        return new AggregationOptions();
    }

    public AggregationOptions verbatim(boolean verbatim) {
        this.verbatim = verbatim;
        return this;
    }

    public AggregationOptions load(String ... attributes) {
        this.load = Arrays.asList(attributes);
        return this;
    }

    public AggregationOptions timeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    public AggregationOptions loadAll() {
        this.loadAll = this.loadAll;
        return this;
    }

    public AggregationOptions groupBy(GroupBy ... groups) {
        this.groupByParams = Arrays.stream(groups).map(g -> (GroupParams)g).collect(Collectors.toList());
        return this;
    }

    public AggregationOptions sortBy(SortedField ... fields) {
        this.sortedByFields = Arrays.asList(fields);
        return this;
    }

    public AggregationOptions sortBy(int max, SortedField ... fields) {
        this.sortedByMax = max;
        this.sortedByFields = Arrays.asList(fields);
        return this;
    }

    public AggregationOptions apply(Expression ... expressions) {
        this.expressions = Arrays.asList(expressions);
        return this;
    }

    public AggregationOptions limit(int offset, int count) {
        this.offset = offset;
        this.count = count;
        return this;
    }

    public AggregationOptions filter(String filter) {
        this.filter = filter;
        return this;
    }

    public AggregationOptions withCursor() {
        this.withCursor = true;
        return this;
    }

    public AggregationOptions withCursor(int count) {
        this.withCursor = true;
        this.cursorCount = count;
        return this;
    }

    public AggregationOptions withCursor(int count, int maxIdle) {
        this.withCursor = true;
        this.cursorCount = count;
        this.cursorMaxIdle = maxIdle;
        return this;
    }

    public AggregationOptions params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public AggregationOptions dialect(Integer dialect) {
        this.dialect = dialect;
        return this;
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public List<String> getLoad() {
        return this.load;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public boolean isLoadAll() {
        return this.loadAll;
    }

    public List<GroupParams> getGroupByParams() {
        return this.groupByParams;
    }

    public List<SortedField> getSortedByFields() {
        return this.sortedByFields;
    }

    public Integer getSortedByMax() {
        return this.sortedByMax;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isWithCursor() {
        return this.withCursor;
    }

    public Integer getCursorCount() {
        return this.cursorCount;
    }

    public Integer getCursorMaxIdle() {
        return this.cursorMaxIdle;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Integer getDialect() {
        return this.dialect;
    }
}

