/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.chain;

import cn.sliew.milky.common.chain.AbstractPipelineProcess;
import cn.sliew.milky.common.chain.Command;
import cn.sliew.milky.common.chain.Context;
import cn.sliew.milky.common.chain.PipelineException;
import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.log.Logger;
import java.util.concurrent.CompletableFuture;

public class LogCommand
implements Command<String, Object> {
    public static final String NAME = "LogCommand";
    private final Logger logger;

    public LogCommand(Logger logger) {
        this.logger = Ensures.checkNotNull(logger);
    }

    @Override
    public void onEvent(AbstractPipelineProcess<String, Object> process, Context<String, Object> context, CompletableFuture<?> future) {
        this.logger.info("process: {}, context: {}", (Object)process, (Object)context);
        process.fireEvent(context, future);
    }

    @Override
    public void exceptionCaught(AbstractPipelineProcess<String, Object> process, Context<String, Object> context, CompletableFuture<?> future, Throwable cause) throws PipelineException {
        this.logger.error(cause.getMessage(), cause);
        process.fireExceptionCaught(context, future, cause);
    }
}

