/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.watch.source;

import cn.sliew.carp.module.kubernetes.service.entity.VersionGroupKind;
import cn.sliew.milky.common.util.JacksonUtil;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.informers.ExceptionHandler;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.stage.AbstractOutHandler;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogicWithLogging;
import org.springframework.util.StringUtils;

public class K8sResourceSource
extends GraphStage<SourceShape<GenericKubernetesResource>> {
    private static final Attributes DEFAULT_ATTRIBUTES = Attributes.name((String)"KubernetesResourceSource");
    private final VersionGroupKind gvk;
    private final KubernetesClient kubernetesClient;
    private final Integer maxBufferSize = 100;
    private final Outlet<GenericKubernetesResource> out = Outlet.create((String)"KubernetesResourceSource.out");
    private final SourceShape<GenericKubernetesResource> shape = SourceShape.of(this.out);

    public K8sResourceSource(VersionGroupKind gvk, KubernetesClient kubernetesClient) {
        this.gvk = gvk;
        this.kubernetesClient = kubernetesClient;
    }

    public SourceShape<GenericKubernetesResource> shape() {
        return this.shape;
    }

    public Attributes initialAttributes() {
        return DEFAULT_ATTRIBUTES;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) throws IOException {
        return new KubernetesTimerGraphStageLogic(this.shape);
    }

    private class KubernetesTimerGraphStageLogic
    extends TimerGraphStageLogicWithLogging
    implements ResourceEventHandler<GenericKubernetesResource>,
    ExceptionHandler {
        private final Queue<GenericKubernetesResource> buffer;

        public KubernetesTimerGraphStageLogic(SourceShape<GenericKubernetesResource> shape) {
            super(shape);
            this.buffer = new ArrayDeque<GenericKubernetesResource>();
            this.setHandler(K8sResourceSource.this.out, (OutHandler)new AbstractOutHandler(){

                public void onPull() throws Exception {
                    if (!KubernetesTimerGraphStageLogic.this.buffer.isEmpty()) {
                        KubernetesTimerGraphStageLogic.this.pushHead();
                    }
                }
            });
        }

        public void onTimer(Object timerKey) {
            if (!this.isClosed(K8sResourceSource.this.out)) {
                this.doPoll();
                if (!this.buffer.isEmpty()) {
                    this.pushHead();
                }
            }
        }

        public void preStart() throws Exception {
            MixedOperation operation = K8sResourceSource.this.kubernetesClient.genericKubernetesResources(K8sResourceSource.this.gvk.getApiVersion(), K8sResourceSource.this.gvk.getKind());
            if (StringUtils.hasText((String)K8sResourceSource.this.gvk.getNamespace())) {
                NonNamespaceOperation namespaceOperation = (NonNamespaceOperation)operation.inNamespace(K8sResourceSource.this.gvk.getNamespace());
                if (StringUtils.hasText((String)K8sResourceSource.this.gvk.getName())) {
                    ((Resource)namespaceOperation.withName(K8sResourceSource.this.gvk.getName())).inform().addEventHandler((ResourceEventHandler)this).start();
                } else {
                    namespaceOperation.inform().addEventHandler((ResourceEventHandler)this).start();
                }
            } else {
                ((AnyNamespaceOperation)operation.inAnyNamespace()).inform().addEventHandler((ResourceEventHandler)this).start();
            }
        }

        public void postStop() {
            this.buffer.clear();
        }

        private void pushHead() {
            GenericKubernetesResource head;
            if (this.isAvailable(K8sResourceSource.this.out) && (head = this.buffer.poll()) != null) {
                this.push(K8sResourceSource.this.out, head);
            }
        }

        private void doPoll() {
            MixedOperation operation = K8sResourceSource.this.kubernetesClient.genericKubernetesResources(K8sResourceSource.this.gvk.getApiVersion(), K8sResourceSource.this.gvk.getKind());
            if (StringUtils.hasText((String)K8sResourceSource.this.gvk.getNamespace())) {
                this.buffer.addAll(this.inNamespace((MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>>)operation));
            } else {
                this.buffer.addAll(this.inAnyNamespace((MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>>)operation));
            }
            if (this.buffer.size() > K8sResourceSource.this.maxBufferSize) {
                this.failStage(new RuntimeException("Max event buffer size " + K8sResourceSource.this.maxBufferSize + " reached for gvk: " + JacksonUtil.toJsonString((Object)K8sResourceSource.this.gvk)));
            }
        }

        private List<GenericKubernetesResource> inNamespace(MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> operation) {
            NonNamespaceOperation namespaceOperation = (NonNamespaceOperation)operation.inNamespace(K8sResourceSource.this.gvk.getNamespace());
            if (StringUtils.hasText((String)K8sResourceSource.this.gvk.getName())) {
                return Collections.singletonList((GenericKubernetesResource)((Resource)namespaceOperation.withName(K8sResourceSource.this.gvk.getName())).get());
            }
            return ((GenericKubernetesResourceList)namespaceOperation.list()).getItems();
        }

        private List<GenericKubernetesResource> inAnyNamespace(MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> operation) {
            if (StringUtils.hasText((String)K8sResourceSource.this.gvk.getName())) {
                this.failStage(new IllegalArgumentException("gvk must have namespace when name exists! gvk: " + JacksonUtil.toJsonString((Object)K8sResourceSource.this.gvk)));
                return Collections.emptyList();
            }
            return ((GenericKubernetesResourceList)operation.list()).getItems();
        }

        public boolean retryAfterException(boolean isStarted, Throwable t) {
            this.failStage(t);
            return false;
        }

        public void onAdd(GenericKubernetesResource obj) {
            this.onEvent(obj);
        }

        public void onUpdate(GenericKubernetesResource oldObj, GenericKubernetesResource newObj) {
            this.onEvent(newObj);
        }

        public void onDelete(GenericKubernetesResource obj, boolean deletedFinalStateUnknown) {
            this.onEvent(obj);
        }

        private void onEvent(GenericKubernetesResource obj) {
            ObjectMeta metadata = obj.getMetadata();
            this.log().info("\u63a8\u9001: {}: {}", (Object)metadata.getNamespace(), (Object)metadata.getName());
            this.buffer.add(obj);
            if (this.buffer.size() > K8sResourceSource.this.maxBufferSize) {
                this.failStage(new RuntimeException("Max event buffer size " + K8sResourceSource.this.maxBufferSize + " reached for gvk: " + JacksonUtil.toJsonString((Object)K8sResourceSource.this.gvk)));
            }
            if (!this.buffer.isEmpty()) {
                this.pushHead();
            }
        }
    }
}

