/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.util;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class LogByteStringTools$ {
    public static LogByteStringTools$ MODULE$;
    private final int MaxBytesPrinted;
    private final Attributes LogFailuresOnDebugAttributes;

    static {
        new LogByteStringTools$();
    }

    public int MaxBytesPrinted() {
        return this.MaxBytesPrinted;
    }

    private Attributes LogFailuresOnDebugAttributes() {
        return this.LogFailuresOnDebugAttributes;
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> logByteStringBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logByteString(new StringBuilder(5).append(name).append(" DOWN").toString(), maxBytes), this.logByteString(new StringBuilder(5).append(name).append(" UP  ").toString(), maxBytes));
    }

    public <A, B> BidiFlow<A, A, B, B, NotUsed> logToStringBidi(String name, int maxBytes, ClassTag<A> evidence$1, ClassTag<B> evidence$2) {
        return BidiFlow$.MODULE$.fromFlows(this.logToString(new StringBuilder(1).append(name).append(" ").append(LogByteStringTools$.limitedName$1(evidence$1)).toString(), maxBytes), this.logToString(new StringBuilder(1).append(name).append(" ").append(LogByteStringTools$.limitedName$1(evidence$2)).toString(), maxBytes));
    }

    public Flow<ByteString, ByteString, NotUsed> logByteString(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.printByteString((ByteString)x$1, maxBytes, MODULE$.printByteString$default$3(), MODULE$.printByteString$default$4());
        LoggingAdapter x$3 = qual$1.log$default$3(name, (Function1)x$2);
        return ((Flow)qual$1.log(name, (Function1)x$2, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logByteStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public int logByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> Flow<A, A, NotUsed> logToString(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        Function1 & Serializable & scala.Serializable x$22 = (Function1 & Serializable & scala.Serializable)x$2 -> (String)new StringOps(Predef$.MODULE$.augmentString(x$2.toString())).take(maxBytes);
        LoggingAdapter x$3 = qual$1.log$default$3(name, (Function1)x$22);
        return ((Flow)qual$1.log(name, (Function1)x$22, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public <A, B> int logToStringBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public <A> int logToString$default$2() {
        return this.MaxBytesPrinted();
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTLSBidi(String name, int maxBytes) {
        return BidiFlow$.MODULE$.fromFlows(this.logTlsOutbound(new StringBuilder(8).append(name).append(" ToNet  ").toString(), maxBytes), this.logTlsInbound(new StringBuilder(8).append(name).append(" FromNet").toString(), maxBytes));
    }

    public int logTLSBidi$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, NotUsed> logTlsOutbound(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof TLSProtocol.SendBytes) {
                ByteString bytes = ((TLSProtocol.SendBytes)x0$1).bytes();
                return new StringBuilder(10).append("SendBytes ").append(MODULE$.printByteString(bytes, maxBytes, MODULE$.printByteString$default$3(), MODULE$.printByteString$default$4())).toString();
            }
            if (x0$1 instanceof TLSProtocol.NegotiateNewSession) {
                return ((TLSProtocol.NegotiateNewSession)x0$1).toString();
            }
            throw new MatchError(x0$1);
        };
        LoggingAdapter x$3 = qual$1.log$default$3(name, (Function1)x$2);
        return ((Flow)qual$1.log(name, (Function1)x$2, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logTlsOutbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public Flow<TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, NotUsed> logTlsInbound(String name, int maxBytes) {
        Flow qual$1 = Flow$.MODULE$.apply();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof TLSProtocol.SessionTruncated) {
                return (TLSProtocol.SessionTruncated)x0$1;
            }
            if (x0$1 instanceof TLSProtocol.SessionBytes) {
                ByteString bytes = ((TLSProtocol.SessionBytes)x0$1).bytes();
                return new StringBuilder(13).append("SessionBytes ").append(MODULE$.printByteString(bytes, maxBytes, MODULE$.printByteString$default$3(), MODULE$.printByteString$default$4())).toString();
            }
            throw new MatchError(x0$1);
        };
        LoggingAdapter x$3 = qual$1.log$default$3(name, (Function1)x$2);
        return ((Flow)qual$1.log(name, (Function1)x$2, x$3)).addAttributes(this.LogFailuresOnDebugAttributes());
    }

    public int logTlsInbound$default$2() {
        return this.MaxBytesPrinted();
    }

    public String printByteString(ByteString bytes, int maxBytes, boolean addPrefix, String indent) {
        return LogByteStringTools$.formatBytes$1(bytes, indent, maxBytes, addPrefix).mkString("");
    }

    public int printByteString$default$2() {
        return this.MaxBytesPrinted();
    }

    public boolean printByteString$default$3() {
        return true;
    }

    public String printByteString$default$4() {
        return " ";
    }

    public char asASCII(byte b) {
        if (b >= 32 && b < 127) {
            return (char)b;
        }
        return '.';
    }

    public BidiFlow<TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsOutbound, TLSProtocol.SslTlsInbound, TLSProtocol.SslTlsInbound, Object> logTLSBidiBySetting(String tag, Option<Object> maxBytesSetting) {
        return (BidiFlow)maxBytesSetting.map((Function1 & Serializable & scala.Serializable)x$3 -> LogByteStringTools$.MODULE$.logTLSBidi(tag, BoxesRunTime.unboxToInt((Object)x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> BidiFlow$.MODULE$.identity());
    }

    private static final String limitedName$1(ClassTag tag) {
        return new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(Logging$.MODULE$.simpleName(tag.runtimeClass()))).take(20))).mkString();
    }

    private static final String asHex$1(byte b) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)b)}));
    }

    private static final String formatLine$1(ByteString bs, String indent$1) {
        String hex = ((TraversableOnce)bs.map((Function1 & Serializable & scala.Serializable)b -> LogByteStringTools$.asHex$1(BoxesRunTime.unboxToByte((Object)b)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" ");
        String ascii = ((TraversableOnce)bs.map((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToCharacter((char)LogByteStringTools$.MODULE$.asASCII(BoxesRunTime.unboxToByte((Object)b))), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
        return new StringOps("%s%-48s | %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indent$1, hex, ascii}));
    }

    private static final String formatBytes$2(ByteString bs2, String indent$1) {
        return bs2.grouped(16).map((Function1 & Serializable & scala.Serializable)bs -> LogByteStringTools$.formatLine$1(bs, indent$1)).mkString("\n");
    }

    private static final Iterator formatBytes$1(ByteString bs, String indent$1, int maxBytes$5, boolean addPrefix$1) {
        String prefix = new StringBuilder(18).append(indent$1).append("ByteString(").append(bs.size()).append(" bytes)").toString();
        if (bs.size() <= maxBytes$5 * 2) {
            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{addPrefix$1 ? new StringBuilder(1).append(prefix).append("\n").toString() : "", LogByteStringTools$.formatBytes$2(bs, indent$1)}));
        }
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{addPrefix$1 ? new StringBuilder(16).append(prefix).append(" first + last ").append(maxBytes$5).append(":\n").toString() : "", LogByteStringTools$.formatBytes$2(bs.take(maxBytes$5), indent$1), new StringBuilder(46).append("\n").append(indent$1).append("                    ... [").append(bs.size() - maxBytes$5 * 2).append(" bytes omitted] ...\n").toString(), LogByteStringTools$.formatBytes$2(bs.takeRight(maxBytes$5), indent$1)}));
    }

    private LogByteStringTools$() {
        MODULE$ = this;
        this.MaxBytesPrinted = 80;
        int x$1 = Logging$.MODULE$.DebugLevel();
        int x$2 = Attributes$.MODULE$.logLevels$default$1();
        int x$3 = Attributes$.MODULE$.logLevels$default$2();
        this.LogFailuresOnDebugAttributes = Attributes$.MODULE$.logLevels(x$2, x$3, x$1);
    }
}

