/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;

class JedisClientUtils {
    private static final Set<String> KNOWN_COMMANDS = Arrays.stream(Protocol.Command.values()).map(Enum::name).collect(Collectors.toSet());

    JedisClientUtils() {
    }

    public static ProtocolCommand getCommand(String command) {
        if (JedisClientUtils.isKnownCommand(command)) {
            return Protocol.Command.valueOf((String)command.trim().toUpperCase());
        }
        return () -> JedisConverters.toBytes(command);
    }

    private static boolean isKnownCommand(String command) {
        return KNOWN_COMMANDS.contains(command);
    }
}

