/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.domain.geo;

import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Shape;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.BoxShape;
import org.springframework.data.redis.domain.geo.RadiusShape;

public interface GeoShape
extends Shape {
    public static GeoShape byRadius(Distance radius) {
        return new RadiusShape(radius);
    }

    public static GeoShape byBox(double width, double height, RedisGeoCommands.DistanceUnit distanceUnit) {
        return GeoShape.byBox(new BoundingBox(width, height, distanceUnit));
    }

    public static GeoShape byBox(BoundingBox boundingBox) {
        return new BoxShape(boundingBox);
    }

    public Metric getMetric();
}

