/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.biz.ext.validation;

import cn.sliew.carp.framework.common.dict.DictDefinition;
import cn.sliew.carp.framework.common.dict.EnumDictRegistry;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Optional;

@Documented
@Constraint(validatedBy={DictValidator.class})
@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface DictConstraint {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String dict();

    public static class DictValidator
    implements ConstraintValidator<DictConstraint, String> {
        private DictConstraint constraint;

        public void initialize(DictConstraint constraint) {
            this.constraint = constraint;
        }

        public boolean isValid(String value, ConstraintValidatorContext context) {
            if (Objects.isNull(this.constraint.dict()) || Objects.isNull(value)) {
                context.buildConstraintViolationWithTemplate("[Dict Instance] is invalid").addConstraintViolation();
                return false;
            }
            Optional optional = EnumDictRegistry.INSTANCE.getDictDefinition(this.constraint.dict());
            if (optional.isEmpty()) {
                context.buildConstraintViolationWithTemplate("[Dict] is invalid").addConstraintViolation();
                return false;
            }
            if (!EnumDictRegistry.INSTANCE.exists((DictDefinition)optional.get(), value)) {
                context.buildConstraintViolationWithTemplate("[Dict Instance] is invalid").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

