/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.biz.ext.fastexcel.handler;

import cn.hutool.http.HttpUtil;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.metadata.data.CellData;
import cn.idev.excel.metadata.data.ImageData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.write.handler.CellWriteHandler;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import cn.idev.excel.write.metadata.holder.WriteTableHolder;
import cn.sliew.carp.framework.biz.ext.fastexcel.annotation.ExcelImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.Units;

public class ImageCellWriteHandler
implements CellWriteHandler {
    private List<String> repeats = new ArrayList<String>();

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        if (isHead.booleanValue()) {
            return;
        }
        Object data = cellData.getData();
        if (cellData.getImageDataList() != null || data instanceof ArrayList) {
            cellData.setType(CellDataTypeEnum.EMPTY);
            return;
        }
        this.handlerExcelImage(cellData, cell, head);
    }

    private void handlerExcelImage(WriteCellData<?> cellData, Cell cell, Head head) {
        ExcelImage excelImage = head.getField().getAnnotation(ExcelImage.class);
        String stringValue = cellData.getStringValue();
        if (Objects.nonNull(excelImage) && Objects.nonNull(stringValue)) {
            if (!excelImage.isMultiple()) {
                cellData.setType(CellDataTypeEnum.RICH_TEXT_STRING);
                ImageData imageData = this.downloadImageData(stringValue, excelImage);
                if (Objects.nonNull(imageData)) {
                    cellData.setImageDataList(Collections.singletonList(imageData));
                }
            } else {
                cellData.setType(CellDataTypeEnum.EMPTY);
                List<String> list = Arrays.asList(stringValue.replace("\uff0c", ",").split(","));
                Sheet sheet = cell.getSheet();
                int maxColumnWidth = Math.max(sheet.getColumnWidth(cell.getColumnIndex()), 1920 * list.size());
                sheet.setColumnWidth(cell.getColumnIndex(), maxColumnWidth);
                List imageDataList = list.stream().map(u -> this.downloadImageData((String)u, excelImage)).filter(Objects::nonNull).collect(Collectors.toList());
                for (int i = 0; i < imageDataList.size(); ++i) {
                    this.insertImage(sheet, cell, ((ImageData)imageDataList.get(i)).getImage(), i);
                }
            }
        }
    }

    private ImageData downloadImageData(String strUrl, ExcelImage excelImage) {
        byte[] bytes = HttpUtil.downloadBytes((String)strUrl);
        ImageData imageData = new ImageData();
        imageData.setImage(bytes);
        imageData.setAnchorType(excelImage.anchorType());
        return imageData;
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        if (isHead.booleanValue() || CollectionUtils.isEmpty(cellDataList)) {
            return;
        }
        WriteCellData<?> writeCellData = cellDataList.get(0);
        if (writeCellData.getData() != null && writeCellData.getData() instanceof ArrayList) {
            String key = cell.getRowIndex() + "_" + cell.getColumnIndex();
            if (this.repeats.contains(key)) {
                return;
            }
            this.repeats.add(key);
            List cellDatas = (List)writeCellData.getData();
            Sheet sheet = cell.getSheet();
            sheet.getRow(cell.getRowIndex()).setHeight((short)900);
            int maxColumnWidth = Math.max(sheet.getColumnWidth(cell.getColumnIndex()), 1920 * cellDatas.size());
            sheet.setColumnWidth(cell.getColumnIndex(), maxColumnWidth);
            for (int i = 0; i < cellDatas.size(); ++i) {
                this.insertImage(sheet, cell, (byte[])((CellData)cellDatas.get(i)).getData(), i);
            }
        }
    }

    private void insertImage(Sheet sheet, Cell cell, byte[] pictureData, int i) {
        int picWidth = Units.pixelToEMU((int)60);
        int index = sheet.getWorkbook().addPicture(pictureData, 6);
        Drawing drawing = sheet.getDrawingPatriarch();
        if (drawing == null) {
            drawing = sheet.createDrawingPatriarch();
        }
        CreationHelper helper = sheet.getWorkbook().getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setDx1(picWidth * i);
        anchor.setDx2(picWidth + picWidth * i);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        anchor.setRow2(cell.getRowIndex() + 1);
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        drawing.createPicture(anchor, index);
    }
}

