/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.biz.ext.fastexcel.converters;

import cn.idev.excel.converters.Converter;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.exception.ExcelDataConvertException;
import cn.idev.excel.metadata.GlobalConfiguration;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.sliew.carp.framework.common.dict.CarpEnumDictRegistry;
import cn.sliew.carp.framework.common.dict.Dict;
import cn.sliew.carp.framework.common.dict.DictDefinition;
import cn.sliew.carp.framework.common.dict.DictInstance;
import cn.sliew.carp.framework.common.dict.DictRegistry;
import java.util.Objects;
import java.util.Optional;

public class DictConverter
implements Converter<DictInstance> {
    private DictRegistry dictRegistry = CarpEnumDictRegistry.INSTANCE;

    public Class<?> supportJavaTypeKey() {
        return DictInstance.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public DictInstance convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String value = cellData.getStringValue();
        try {
            Dict dictEnum = contentProperty.getField().getAnnotation(Dict.class);
            if (Objects.nonNull(dictEnum) && Objects.nonNull(value)) {
                String code = dictEnum.code();
                Optional optional = this.dictRegistry.getDictDefinition(code);
                if (optional.isEmpty()) {
                    throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "unknown dict code");
                }
                Optional dictInstance = this.dictRegistry.getDictInstance((DictDefinition)optional.get(), value);
                if (dictInstance.isEmpty()) {
                    throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "unknown dict instance code");
                }
                return (DictInstance)dictInstance.get();
            }
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, "field must contains Dict annotation");
        }
        catch (Exception e) {
            throw new ExcelDataConvertException(cellData.getRowIndex(), cellData.getColumnIndex(), cellData, contentProperty, e.getMessage(), (Throwable)e);
        }
    }

    public WriteCellData<?> convertToExcelData(DictInstance value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new WriteCellData(value.getValue());
    }
}

