/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.biz.ext.fastexcel.converters.number.money;

import cn.idev.excel.converters.Converter;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.GlobalConfiguration;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import cn.sliew.milky.common.unit.MoneyUnit;
import cn.sliew.milky.common.unit.MoneyValue;
import java.math.BigDecimal;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MoneyFen2YuanConverter
implements Converter<Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MoneyFen2YuanConverter.class);

    public Class supportJavaTypeKey() {
        return Long.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.NUMBER;
    }

    public Long convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        Object stringValue = cellData.getStringValue();
        if (cellData.getType().equals((Object)CellDataTypeEnum.NUMBER)) {
            stringValue = String.valueOf(cellData.getNumberValue());
        }
        if (Objects.isNull(stringValue) || StringUtils.isEmpty((Object)stringValue)) {
            return null;
        }
        MoneyValue moneyValue = new MoneyValue(new BigDecimal((String)stringValue), MoneyUnit.YUAN);
        return moneyValue.getHao().longValue();
    }

    public WriteCellData<?> convertToExcelData(Long value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (Objects.isNull(value)) {
            return new WriteCellData("");
        }
        MoneyValue moneyValue = new MoneyValue(new BigDecimal(value), MoneyUnit.FEN);
        return new WriteCellData(moneyValue.getFen());
    }
}

