/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.license;

import cn.sliew.carp.framework.common.dict.license.LicenseType;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;

public class CarpLicense {
    private LicenseType type;
    private LocalDateTime expireTime;

    public boolean isValid() {
        if (Objects.nonNull(this.type) && Objects.nonNull(this.expireTime)) {
            return Duration.between(this.expireTime, LocalDateTime.now()).toMillis() < 0L;
        }
        return false;
    }

    public boolean isPro() {
        return this.isValid() && (this.type == LicenseType.PRO || this.type == LicenseType.ENTERPRISE);
    }

    public boolean isEnterprise() {
        return this.isValid() && this.type == LicenseType.ENTERPRISE;
    }

    @Generated
    public CarpLicense() {
    }

    @Generated
    public LicenseType getType() {
        return this.type;
    }

    @Generated
    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    @Generated
    public void setType(LicenseType type) {
        this.type = type;
    }

    @Generated
    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CarpLicense)) {
            return false;
        }
        CarpLicense other = (CarpLicense)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LicenseType this$type = this.getType();
        LicenseType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        LocalDateTime this$expireTime = this.getExpireTime();
        LocalDateTime other$expireTime = other.getExpireTime();
        return !(this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CarpLicense;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LicenseType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        LocalDateTime $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CarpLicense(type=" + this.getType() + ", expireTime=" + this.getExpireTime() + ")";
    }
}

