/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.license.aop;

import cn.sliew.carp.framework.license.CarpLicense;
import java.lang.reflect.Method;
import java.util.Objects;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseAspect.class);
    @Autowired(required=false)
    private CarpLicense license;

    @Pointcut(value="@annotation(cn.sliew.carp.framework.license.annotation.ValidLicenseEnabled)")
    public void validLicensePointcut() {
    }

    @Pointcut(value="@annotation(cn.sliew.carp.framework.license.annotation.ProLicenseEnabled)")
    public void proLicensePointcut() {
    }

    @Pointcut(value="@annotation(cn.sliew.carp.framework.license.annotation.EnterpriseLicenseEnabled)")
    public void enterpriseLicensePointcut() {
    }

    @Before(value="validLicensePointcut()")
    public void beforeValidLicenseCheck(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (Objects.nonNull(this.license) && this.license.isValid()) {
            return;
        }
        throw new RuntimeException("license invalid or expired");
    }

    @Before(value="proLicensePointcut()")
    public void beforeProLicenseCheck(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (Objects.nonNull(this.license) && this.license.isPro()) {
            return;
        }
        throw new RuntimeException("license invalid or expired");
    }

    @Before(value="enterpriseLicensePointcut()")
    public void beforeEnterpriseLicenseCheck(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (Objects.nonNull(this.license) && this.license.isEnterprise()) {
            return;
        }
        throw new RuntimeException("license invalid or expired");
    }
}

