/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.support.generator.helper;

import cn.sliew.carp.framework.mybatis.entity.BaseAuditDO;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.IFill;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.IKeyWordsHandler;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.Controller;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.builder.Mapper;
import com.baomidou.mybatisplus.generator.config.builder.Service;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.PostgreSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.querys.MySqlQuery;
import com.baomidou.mybatisplus.generator.config.querys.PostgreSqlQuery;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.fill.Column;
import com.baomidou.mybatisplus.generator.fill.Property;
import com.baomidou.mybatisplus.generator.keywords.MySqlKeyWordsHandler;
import com.baomidou.mybatisplus.generator.keywords.PostgreSqlKeyWordsHandler;

public class MybatisPlusHelper {
    private static final String TABLE_PREFIX = "";

    public static void generatorMySQL(String jdbcUrl, String jdbcUserName, String jdbcPassword, String author, String basePackage, String moduleName, String[] tables) {
        MybatisPlusHelper.doGenerator(MybatisPlusHelper.mysqlDataSourceConfig(jdbcUrl, jdbcUserName, jdbcPassword), author, basePackage, moduleName, tables);
    }

    public static void generatorPostgreSQL(String jdbcUrl, String jdbcUserName, String jdbcPassword, String schema, String author, String basePackage, String moduleName, String[] tables) {
        MybatisPlusHelper.doGenerator(MybatisPlusHelper.postgresqlDataSourceConfig(jdbcUrl, jdbcUserName, jdbcPassword, schema), author, basePackage, moduleName, tables);
    }

    public static void doGenerator(DataSourceConfig.Builder dataSourceConfigBuilder, String author, String basePackage, String moduleName, String[] tables) {
        FastAutoGenerator generator = FastAutoGenerator.create((DataSourceConfig.Builder)dataSourceConfigBuilder).globalConfig(builder -> MybatisPlusHelper.globalConfig(builder, author)).packageConfig(builder -> MybatisPlusHelper.packageConfig(builder, basePackage, moduleName)).templateConfig(MybatisPlusHelper::templateConfig).strategyConfig(builder -> MybatisPlusHelper.strategyConfig(builder, tables)).injectionConfig(MybatisPlusHelper::injectionConfig);
        generator.execute();
    }

    private static DataSourceConfig.Builder mysqlDataSourceConfig(String jdbcUrl, String jdbcUserName, String password) {
        return new DataSourceConfig.Builder(jdbcUrl, jdbcUserName, password).dbQuery((IDbQuery)new MySqlQuery()).typeConvert((ITypeConvert)new MySqlTypeConvert()).keyWordsHandler((IKeyWordsHandler)new MySqlKeyWordsHandler());
    }

    private static DataSourceConfig.Builder postgresqlDataSourceConfig(String jdbcUrl, String jdbcUserName, String password, String schema) {
        return new DataSourceConfig.Builder(jdbcUrl, jdbcUserName, password).schema(schema).dbQuery((IDbQuery)new PostgreSqlQuery()).typeConvert((ITypeConvert)new PostgreSqlTypeConvert()).keyWordsHandler((IKeyWordsHandler)new PostgreSqlKeyWordsHandler());
    }

    private static void globalConfig(GlobalConfig.Builder builder, String author) {
        builder.outputDir(System.getProperty("user.dir") + "/carp-support/carp-generator/src/main/java/").author(author).enableSpringdoc().dateType(DateType.ONLY_DATE).commentDate("yyyy-MM-dd");
    }

    private static void packageConfig(PackageConfig.Builder builder, String basePackage, String moduleName) {
        builder.parent(basePackage).moduleName(moduleName).entity("dao.entity").service("service").serviceImpl("service.impl").mapper("dao.mapper").xml("dao.mapper").controller("api.controller");
    }

    private static void templateConfig(TemplateConfig.Builder builder) {
        builder.controller(null).service(null).serviceImpl(null).entity("/custom-entity.java.vm");
    }

    private static void strategyConfig(StrategyConfig.Builder builder, String[] tables) {
        builder.enableCapitalMode().enableSkipView().disableSqlFilter().addInclude(tables).addTablePrefix(new String[]{TABLE_PREFIX});
        Entity.Builder entityBuilder = builder.entityBuilder();
        entityBuilder.superClass(BaseAuditDO.class).enableLombok().enableTableFieldAnnotation().enableRemoveIsPrefix().naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel).addSuperEntityColumns(new String[]{"id", "creator", "created_time", "editor", "update_time"}).idType(IdType.AUTO).addTableFills(new IFill[]{new Column("create_time", FieldFill.INSERT)}).addTableFills(new IFill[]{new Property("updateTime", FieldFill.INSERT_UPDATE)}).formatFileName("%s");
        Mapper.Builder mapperBuilder = builder.mapperBuilder();
        mapperBuilder.superClass(BaseMapper.class).enableMapperAnnotation().enableBaseResultMap().enableBaseColumnList().formatMapperFileName("%sMapper").formatXmlFileName("%sMapper");
        Service.Builder serviceBuilder = builder.serviceBuilder();
        serviceBuilder.formatServiceFileName("%sService").formatServiceImplFileName("%sServiceImp").build();
        Controller.Builder controllerBuilder = builder.controllerBuilder();
        controllerBuilder.enableHyphenStyle().enableRestStyle().formatFileName("%sController").build();
    }

    private static void injectionConfig(InjectionConfig.Builder builder) {
    }
}

