/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.example.hazelcast.controller;

import cn.sliew.carp.example.hazelcast.computing.EchoRunnable;
import cn.sliew.carp.example.hazelcast.computing.IntegerCallable;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.durableexecutor.DurableExecutorServiceFuture;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carp/example/hazelcast/computing"})
@Tag(name="\u6d4b\u8bd5\u6a21\u5757-\u5206\u5e03\u5f0f\u8ba1\u7b97")
public class ComputingController {
    @Autowired
    private HazelcastInstance hazelcastInstance;

    @PostMapping(value={"/callable"})
    @Operation(summary="\u6267\u884c Callable \u4efb\u52a1")
    public Integer submitCallable() throws Exception {
        IExecutorService executorService = this.hazelcastInstance.getExecutorService("executorService");
        Future future = executorService.submit((Callable)new IntegerCallable());
        return (Integer)future.get();
    }

    @PostMapping(value={"/runnable"})
    @Operation(summary="\u6267\u884c Runnable \u4efb\u52a1")
    public void submitRunnable(@RequestParam(value="input") String input) throws Exception {
        IExecutorService executorService = this.hazelcastInstance.getExecutorService("executorService");
        Future future = executorService.submit((Runnable)new EchoRunnable(input));
        future.get();
    }

    @PostMapping(value={"/durable-runnable"})
    @Operation(summary="\u6267\u884c DurableRunnable \u4efb\u52a1")
    public void submitDurationRunnable(@RequestParam(value="input") String input) throws Exception {
        DurableExecutorService executorService = this.hazelcastInstance.getDurableExecutorService("myDurableExecutorService");
        DurableExecutorServiceFuture future = executorService.submit((Runnable)new EchoRunnable(input));
        future.get();
    }

    @PostMapping(value={"/scheduled-runnable"})
    @Operation(summary="\u8c03\u5ea6 Runnable \u4efb\u52a1")
    public String scheduleRunnable(@RequestParam(value="input") String input) throws Exception {
        IScheduledExecutorService executorService = this.hazelcastInstance.getScheduledExecutorService("myScheduledExecutorService");
        IScheduledFuture future = executorService.scheduleAtFixedRate((Runnable)new EchoRunnable(input), 0L, 5L, TimeUnit.SECONDS);
        String urn = future.getHandler().toUrn();
        return urn;
    }

    @DeleteMapping(value={"/cancel-scheduled-runnable"})
    @Operation(summary="\u53d6\u6d88 Runnable \u8c03\u5ea6\u4efb\u52a1")
    public void cancelScheduledRunnable(@RequestParam(value="urn") String urn) throws Exception {
        IScheduledExecutorService executorService = this.hazelcastInstance.getScheduledExecutorService("myScheduledExecutorService");
        ScheduledTaskHandler handler = ScheduledTaskHandler.of((String)urn);
        IScheduledFuture future = executorService.getScheduledFuture(handler);
        future.cancel(false);
        future.dispose();
    }
}

